/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.create.TagCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IMapDataSetByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ISetTagDataSetsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.SetTagEntitiesExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.DataSetPEByExperimentOrSampleIdentifierValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetTagDataSetsExecutor
extends SetTagEntitiesExecutor<IDataSetId, DataPE>
implements ISetTagDataSetsExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapDataSetByIdExecutor mapDataSetByIdExecutor;

    @Override
    protected String getRelationName() {
        return "tag-datasets";
    }

    @Override
    protected Class<DataPE> getRelatedClass() {
        return DataPE.class;
    }

    @Override
    protected Collection<? extends IDataSetId> getRelatedIds(IOperationContext context, TagCreation creation) {
        return creation.getDataSetIds();
    }

    @Override
    protected Map<IDataSetId, DataPE> map(IOperationContext context, Collection<? extends IDataSetId> relatedIds) {
        return this.mapDataSetByIdExecutor.map(context, relatedIds);
    }

    @Override
    protected void check(IOperationContext context, IDataSetId relatedId, DataPE related) {
        DataSetPEByExperimentOrSampleIdentifierValidator validator = new DataSetPEByExperimentOrSampleIdentifierValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        if (!validator.doValidation(context.getSession().tryGetPerson(), related)) {
            throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
        }
    }
}

