/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.create.TagCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IMapExperimentByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ISetTagExperimentsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.SetTagEntitiesExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExperimentByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetTagExperimentsExecutor
extends SetTagEntitiesExecutor<IExperimentId, ExperimentPE>
implements ISetTagExperimentsExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapExperimentByIdExecutor mapExperimentByIdExecutor;

    @Override
    protected String getRelationName() {
        return "tag-experiments";
    }

    @Override
    protected Class<ExperimentPE> getRelatedClass() {
        return ExperimentPE.class;
    }

    @Override
    protected Collection<? extends IExperimentId> getRelatedIds(IOperationContext context, TagCreation creation) {
        return creation.getExperimentIds();
    }

    @Override
    protected Map<IExperimentId, ExperimentPE> map(IOperationContext context, Collection<? extends IExperimentId> relatedIds) {
        return this.mapExperimentByIdExecutor.map(context, relatedIds);
    }

    @Override
    protected void check(IOperationContext context, IExperimentId relatedId, ExperimentPE related) {
        ExperimentByIdentiferValidator validator = new ExperimentByIdentiferValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        if (!validator.doValidation(context.getSession().tryGetPerson(), related)) {
            throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
        }
    }
}

