/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ICreateMissingTagExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IMapTagByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ISetTagForEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.tag.TagAuthorization;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetTagForEntityExecutor
implements ISetTagForEntityExecutor {
    @Autowired
    private IMapTagByIdExecutor mapTagByIdExecutor;
    @Autowired
    private ICreateMissingTagExecutor createMissingTagExecutor;

    private SetTagForEntityExecutor() {
    }

    public SetTagForEntityExecutor(IMapTagByIdExecutor mapTagByIdExecutor, ICreateMissingTagExecutor createMissingTagExecutor) {
        this.mapTagByIdExecutor = mapTagByIdExecutor;
        this.createMissingTagExecutor = createMissingTagExecutor;
    }

    @Override
    public void setTags(IOperationContext context, IEntityWithMetaprojects entity, Collection<? extends ITagId> tagIds) {
        TagAuthorization authorization = new TagAuthorization(context);
        Map<ITagId, MetaprojectPE> tagMap = this.mapTagByIdExecutor.map(context, tagIds);
        HashSet tags = new HashSet(tagMap.values());
        for (MetaprojectPE metaprojectPE : entity.getMetaprojects()) {
            if (tags.contains(metaprojectPE) || !authorization.canAccess(metaprojectPE)) continue;
            entity.removeMetaproject(metaprojectPE);
        }
        if (tagIds != null) {
            this.createMissingTagExecutor.create(context, tagIds, tagMap);
            for (ITagId iTagId : tagIds) {
                MetaprojectPE tag = tagMap.get(iTagId);
                authorization.checkAccess(tag);
                entity.addMetaproject(tag);
            }
        }
    }
}

