/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.create.TagCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IMapSampleByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ISetTagSamplesExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.SetTagEntitiesExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SampleByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetTagSamplesExecutor
extends SetTagEntitiesExecutor<ISampleId, SamplePE>
implements ISetTagSamplesExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapSampleByIdExecutor mapSampleByIdExecutor;

    @Override
    protected String getRelationName() {
        return "tag-samples";
    }

    @Override
    protected Class<SamplePE> getRelatedClass() {
        return SamplePE.class;
    }

    @Override
    protected Collection<? extends ISampleId> getRelatedIds(IOperationContext context, TagCreation creation) {
        return creation.getSampleIds();
    }

    @Override
    protected Map<ISampleId, SamplePE> map(IOperationContext context, Collection<? extends ISampleId> relatedIds) {
        return this.mapSampleByIdExecutor.map(context, relatedIds);
    }

    @Override
    protected void check(IOperationContext context, ISampleId relatedId, SamplePE related) {
        SampleByIdentiferValidator validator = new SampleByIdentiferValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        if (!validator.doValidation(context.getSession().tryGetPerson(), related)) {
            throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
        }
    }
}

