/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.TagPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ITagAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.tag.TagAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseCreateOrDeleteModification;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseUpdateModification;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import org.springframework.stereotype.Component;

@Component
public class TagAuthorizationExecutor
implements ITagAuthorizationExecutor {
    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="CREATE_TAG")
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.METAPROJECT})
    public void canCreate(IOperationContext context, MetaprojectPE tag) {
        if (!new TagAuthorization(context).canAccess(tag)) {
            throw new UnauthorizedObjectAccessException((IObjectId)new TagPermId(tag.getOwner().getUserId(), tag.getCode()));
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="UPDATE_TAG")
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.METAPROJECT})
    public void canUpdate(IOperationContext context, ITagId id, MetaprojectPE tag) {
        if (!new TagAuthorization(context).canAccess(tag)) {
            throw new UnauthorizedObjectAccessException((IObjectId)id);
        }
    }

    @Override
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.METAPROJECT, DatabaseModificationKind.ObjectKind.DELETION})
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="DELETE_TAG")
    public void canDelete(IOperationContext context, ITagId id, MetaprojectPE tag) {
        if (!new TagAuthorization(context).canAccess(tag)) {
            throw new UnauthorizedObjectAccessException((IObjectId)id);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="GET_TAG")
    public void canGet(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="SEARCH_TAG")
    public void canSearch(IOperationContext context) {
    }
}

