/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.update.TagUpdate;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityToManyRelationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IReindexEntityExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class UpdateTagEntitiesWithCacheExecutor<RELATED_ID, RELATED_PE extends IEntityWithMetaprojects & IEntityInformationWithPropertiesHolder>
extends AbstractUpdateEntityToManyRelationExecutor<TagUpdate, MetaprojectPE, RELATED_ID, RELATED_PE> {
    @Autowired
    private IReindexEntityExecutor reindexObjectExecutor;

    protected abstract Class<RELATED_PE> getRelatedClass();

    protected abstract RELATED_PE getCurrentlyRelated(MetaprojectAssignmentPE var1);

    @Override
    protected void postUpdate(IOperationContext context, Collection<RELATED_PE> allAdded, Collection<RELATED_PE> allRemoved) {
        HashSet<RELATED_PE> entitiesToReindex = new HashSet<RELATED_PE>();
        entitiesToReindex.addAll(allAdded);
        entitiesToReindex.addAll(allRemoved);
        this.reindexObjectExecutor.reindex(context, this.getRelatedClass(), entitiesToReindex);
    }

    @Override
    protected Collection<RELATED_PE> getCurrentlyRelated(MetaprojectPE entity) {
        ArrayList<RELATED_PE> relatedList = new ArrayList<RELATED_PE>();
        for (MetaprojectAssignmentPE assignment : entity.getAssignments()) {
            RELATED_PE related = this.getCurrentlyRelated(assignment);
            if (related == null) continue;
            relatedList.add(related);
        }
        return relatedList;
    }

    @Override
    protected void add(IOperationContext context, MetaprojectPE entity, RELATED_PE related) {
        related.addMetaproject(entity);
    }

    @Override
    protected void remove(IOperationContext context, MetaprojectPE entity, RELATED_PE related) {
        related.removeMetaproject(entity);
    }
}

