/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.TagPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.update.TagUpdate;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IMapTagByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ITagAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IUpdateTagDataSetsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IUpdateTagExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IUpdateTagExperimentsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IUpdateTagMaterialsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IUpdateTagSamplesExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class UpdateTagExecutor
extends AbstractUpdateEntityExecutor<TagUpdate, MetaprojectPE, ITagId, TagPermId>
implements IUpdateTagExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private ITagAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IMapTagByIdExecutor mapTagByIdExecutor;
    @Autowired
    private IUpdateTagExperimentsExecutor updateTagExperimentsExecutor;
    @Autowired
    private IUpdateTagSamplesExecutor updateTagSamplesExecutor;
    @Autowired
    private IUpdateTagDataSetsExecutor updateTagDataSetsExecutor;
    @Autowired
    private IUpdateTagMaterialsExecutor updateTagMaterialsExecutor;

    @Override
    protected ITagId getId(TagUpdate update) {
        return update.getTagId();
    }

    @Override
    protected TagPermId getPermId(MetaprojectPE entity) {
        return new TagPermId(entity.getOwner().getUserId(), entity.getCode());
    }

    @Override
    protected void checkData(IOperationContext context, TagUpdate update) {
        if (update.getTagId() == null) {
            throw new UserFailureException("Tag id cannot be null.");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context, ITagId id, MetaprojectPE entity) {
        this.authorizationExecutor.canUpdate(context, id, entity);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<TagUpdate, MetaprojectPE> batch) {
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            TagUpdate update = (TagUpdate)entry.getKey();
            MetaprojectPE tag = (MetaprojectPE)entry.getValue();
            if (update.getDescription() == null || !update.getDescription().isModified()) continue;
            tag.setDescription((String)update.getDescription().getValue());
        }
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<TagUpdate, MetaprojectPE> batch) {
        this.updateTagExperimentsExecutor.update(context, batch);
        this.updateTagSamplesExecutor.update(context, batch);
        this.updateTagDataSetsExecutor.update(context, batch);
        this.updateTagMaterialsExecutor.update(context, batch);
    }

    @Override
    protected Map<ITagId, MetaprojectPE> map(IOperationContext context, Collection<ITagId> ids) {
        return this.mapTagByIdExecutor.map(context, ids);
    }

    @Override
    protected List<MetaprojectPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getMetaprojectDAO().listByIDs(ids);
    }

    @Override
    protected void save(IOperationContext context, List<MetaprojectPE> entities, boolean clearCache) {
        for (MetaprojectPE entity : entities) {
            this.daoFactory.getMetaprojectDAO().validateAndSaveUpdatedEntity(entity);
        }
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "tag", null);
    }
}

