/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IdListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.update.TagUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IUpdateTagExperimentsWithCacheExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.UpdateTagEntitiesWithCacheExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExperimentByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateTagExperimentsWithCacheExecutor
extends UpdateTagEntitiesWithCacheExecutor<IExperimentId, ExperimentPE>
implements IUpdateTagExperimentsWithCacheExecutor {
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    protected String getRelationName() {
        return "tag-experiments";
    }

    @Override
    protected Class<ExperimentPE> getRelatedClass() {
        return ExperimentPE.class;
    }

    @Override
    protected ExperimentPE getCurrentlyRelated(MetaprojectAssignmentPE entity) {
        return entity.getExperiment();
    }

    @Override
    protected IdListUpdateValue<? extends IExperimentId> getRelatedUpdate(IOperationContext context, TagUpdate update) {
        return update.getExperimentIds();
    }

    @Override
    protected void check(IOperationContext context, MetaprojectPE entity, IExperimentId relatedId, ExperimentPE related) {
        ExperimentByIdentiferValidator validator = new ExperimentByIdentiferValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        if (!validator.doValidation(context.getSession().tryGetPerson(), related)) {
            throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
        }
    }
}

