/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.create.VocabularyCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.create.VocabularyTermCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.IVocabularyId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.VocabularyPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractCreateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.ICreateVocabularyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.ICreateVocabularyTermExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IVocabularyAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CreateProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class CreateVocabularyExecutor
extends AbstractCreateEntityExecutor<VocabularyCreation, VocabularyPE, VocabularyPermId>
implements ICreateVocabularyExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IVocabularyAuthorizationExecutor authorizationExecutor;
    @Autowired
    private ICreateVocabularyTermExecutor createTermExecutor;

    @Override
    protected IObjectId getId(VocabularyPE entity) {
        return new VocabularyPermId(entity.getCode());
    }

    @Override
    protected VocabularyPermId createPermId(IOperationContext context, VocabularyPE entity) {
        return new VocabularyPermId(entity.getCode());
    }

    @Override
    protected void checkData(IOperationContext context, VocabularyCreation creation) {
        if (StringUtils.isEmpty((CharSequence)creation.getCode())) {
            throw new UserFailureException("Code cannot be empty.");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context) {
    }

    @Override
    protected void checkAccess(IOperationContext context, VocabularyPE entity) {
        this.authorizationExecutor.canCreate(context, entity);
    }

    @Override
    protected List<VocabularyPE> createEntities(IOperationContext context, CollectionBatch<VocabularyCreation> batch) {
        final ArrayList<VocabularyPE> vocabularies = new ArrayList<VocabularyPE>();
        final PersonPE person = context.getSession().tryGetPerson();
        new CollectionBatchProcessor<VocabularyCreation>(context, batch){

            @Override
            public void process(VocabularyCreation vocabularyCreation) {
                VocabularyPE vocabulary = new VocabularyPE();
                vocabulary.setCode(vocabularyCreation.getCode());
                vocabulary.setDescription(vocabularyCreation.getDescription());
                vocabulary.setManagedInternally(vocabularyCreation.isManagedInternally());
                vocabulary.setChosenFromList(vocabularyCreation.isChosenFromList());
                vocabulary.setURLTemplate(vocabularyCreation.getUrlTemplate());
                vocabulary.setRegistrator(person);
                vocabularies.add(vocabulary);
            }

            @Override
            public IProgress createProgress(VocabularyCreation object, int objectIndex, int totalObjectCount) {
                return new CreateProgress((ICreation)object, objectIndex, totalObjectCount);
            }
        };
        return vocabularies;
    }

    @Override
    protected void save(IOperationContext context, List<VocabularyPE> entities, boolean clearCache) {
        for (VocabularyPE vocabulary : entities) {
            this.daoFactory.getVocabularyDAO().createOrUpdateVocabulary(vocabulary);
        }
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<VocabularyCreation, VocabularyPE> batch) {
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<VocabularyCreation, VocabularyPE> batch) {
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            VocabularyCreation vocabularyCreation = (VocabularyCreation)entry.getKey();
            List terms = vocabularyCreation.getTerms();
            if (terms == null) continue;
            for (VocabularyTermCreation termCreation : terms) {
                termCreation.setVocabularyId((IVocabularyId)new VocabularyPermId(((VocabularyPE)entry.getValue()).getCode()));
            }
            this.createTermExecutor.create(context, terms);
        }
    }

    @Override
    protected List<VocabularyPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getVocabularyDAO().listAllEntities();
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "vocabulary", null);
    }
}

