/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.create.VocabularyTermCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.IVocabularyId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.VocabularyTermPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.ICreateVocabularyTermExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IMapVocabularyByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IMapVocabularyTermByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IVocabularyTermAuthorizationExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IVocabularyBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateVocabularyTermExecutor
implements ICreateVocabularyTermExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IVocabularyTermAuthorizationExecutor authorizationExecutor;
    @Resource(name="common-business-object-factory")
    private ICommonBusinessObjectFactory businessObjectFactory;
    @Autowired
    private IMapVocabularyByIdExecutor mapVocabularyByIdExecutor;
    @Autowired
    private IMapVocabularyTermByIdExecutor mapVocabularyTermByIdExecutor;

    @Override
    public List<VocabularyTermPermId> create(IOperationContext context, List<VocabularyTermCreation> creations) {
        this.authorizationExecutor.canCreate(context);
        this.checkData(context, creations);
        this.checkAccess(context, creations);
        HashMap<IVocabularyId, LinkedList<VocabularyTermCreation>> termsMap = new HashMap<IVocabularyId, LinkedList<VocabularyTermCreation>>();
        for (VocabularyTermCreation vocabularyTermCreation : creations) {
            LinkedList<VocabularyTermCreation> terms = (LinkedList<VocabularyTermCreation>)termsMap.get(vocabularyTermCreation.getVocabularyId());
            if (terms == null) {
                terms = new LinkedList<VocabularyTermCreation>();
                termsMap.put(vocabularyTermCreation.getVocabularyId(), terms);
            }
            terms.add(vocabularyTermCreation);
        }
        Map vocabularyMap = this.mapVocabularyByIdExecutor.map(context, termsMap.keySet());
        for (Object vocabularyId : termsMap.keySet()) {
            if (vocabularyMap.containsKey(vocabularyId)) continue;
            throw new UserFailureException("Vocabulary " + vocabularyId + " does not exist.");
        }
        HashMap<VocabularyTermCreation, VocabularyTermPE> hashMap = new HashMap<VocabularyTermCreation, VocabularyTermPE>();
        for (Map.Entry entry : vocabularyMap.entrySet()) {
            IVocabularyId vocabularyId = (IVocabularyId)entry.getKey();
            VocabularyPE vocabulary = (VocabularyPE)entry.getValue();
            hashMap.putAll(this.createTerms(context, vocabulary, (Collection)termsMap.get(vocabularyId)));
        }
        ArrayList<VocabularyTermPermId> permIds = new ArrayList<VocabularyTermPermId>(creations.size());
        for (VocabularyTermCreation creation : creations) {
            VocabularyTermPE createdTerm = (VocabularyTermPE)hashMap.get(creation);
            permIds.add(new VocabularyTermPermId(createdTerm.getCode(), createdTerm.getVocabulary().getCode()));
        }
        return permIds;
    }

    private void checkData(IOperationContext context, Collection<VocabularyTermCreation> creations) {
        for (VocabularyTermCreation creation : creations) {
            if (creation.getVocabularyId() == null) {
                throw new UserFailureException("Vocabulary term vocabulary id cannot be null");
            }
            if (creation.getCode() != null && creation.getCode().trim().length() != 0) continue;
            throw new UserFailureException("Vocabulary term code cannot be null or empty.");
        }
    }

    private void checkAccess(IOperationContext context, Collection<VocabularyTermCreation> creations) {
        boolean hasOfficial = false;
        boolean hasUnofficial = false;
        for (VocabularyTermCreation creation : creations) {
            if (creation.isOfficial().booleanValue()) {
                hasOfficial = true;
                continue;
            }
            hasUnofficial = true;
        }
        if (hasOfficial) {
            this.authorizationExecutor.canCreateOfficial(context);
        }
        if (hasUnofficial) {
            this.authorizationExecutor.canCreateUnofficial(context);
        }
    }

    private Map<VocabularyTermCreation, VocabularyTermPE> createTerms(IOperationContext context, VocabularyPE vocabulary, Collection<VocabularyTermCreation> creations) {
        HashMap<VocabularyTermCreation, VocabularyTermPE> results = new HashMap<VocabularyTermCreation, VocabularyTermPE>();
        IVocabularyBO vocabularyBO = this.businessObjectFactory.createVocabularyBO(context.getSession());
        vocabularyBO.loadDataByTechId(new TechId(vocabulary.getId()));
        HashSet<String> existingTermCodes = new HashSet<String>();
        for (VocabularyTermPE existingTerm : vocabulary.getTerms()) {
            existingTermCodes.add(existingTerm.getCode());
        }
        for (VocabularyTermCreation creation : creations) {
            if (existingTermCodes.contains(creation.getCode())) {
                throw new UserFailureException("Vocabulary term " + creation.getCode() + " (" + vocabulary.getCode() + ") already exists.");
            }
            existingTermCodes.add(creation.getCode());
            Long previousTermOrdinal = this.getPreviousTermOrdinal(context, vocabulary, creation);
            if (creation.isOfficial().booleanValue()) {
                VocabularyTerm term = new VocabularyTerm();
                term.setCode(creation.getCode());
                term.setLabel(creation.getLabel());
                term.setDescription(creation.getDescription());
                List<VocabularyTermPE> termPEs = vocabularyBO.addNewTerms(Arrays.asList(term), previousTermOrdinal);
                results.put(creation, termPEs.get(0));
                continue;
            }
            VocabularyTermPE termPE = vocabularyBO.addNewUnofficialTerm(creation.getCode(), creation.getLabel(), creation.getDescription(), previousTermOrdinal);
            results.put(creation, termPE);
        }
        vocabularyBO.save();
        return results;
    }

    private Long getPreviousTermOrdinal(IOperationContext context, VocabularyPE vocabulary, VocabularyTermCreation creation) {
        if (creation.getPreviousTermId() != null) {
            Map previousTermMap = this.mapVocabularyTermByIdExecutor.map(context, Arrays.asList(creation.getPreviousTermId()));
            VocabularyTermPE previousTerm = (VocabularyTermPE)previousTermMap.get(creation.getPreviousTermId());
            if (previousTerm == null) {
                throw new UserFailureException("Position of term " + creation.getCode() + " (" + creation.getVocabularyId() + ") could not be found as the specified previous term " + creation.getPreviousTermId() + " does not exist.");
            }
            if (!previousTerm.getVocabulary().getCode().equals(vocabulary.getCode())) {
                throw new UserFailureException("Position of term " + creation.getCode() + " (" + creation.getVocabularyId() + ") could not be found as the specified previous term " + creation.getPreviousTermId() + " is in a different vocabulary (" + previousTerm.getVocabulary().getCode() + ").");
            }
            Session session = this.daoFactory.getSessionFactory().getCurrentSession();
            session.flush();
            session.refresh((Object)previousTerm);
            return previousTerm.getOrdinal();
        }
        return null;
    }
}

