/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.delete.VocabularyDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.IVocabularyId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IDeleteVocabularyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IMapVocabularyByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IVocabularyAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IVocabularyBO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteVocabularyExecutor
extends AbstractDeleteEntityExecutor<Void, IVocabularyId, VocabularyPE, VocabularyDeletionOptions>
implements IDeleteVocabularyExecutor {
    @Resource(name="common-business-object-factory")
    private ICommonBusinessObjectFactory businessObjectFactory;
    @Autowired
    private IVocabularyAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IMapVocabularyByIdExecutor mapVocabularyByIdExecutor;

    @Override
    protected Map<IVocabularyId, VocabularyPE> map(IOperationContext context, List<? extends IVocabularyId> entityIds, VocabularyDeletionOptions deletionOptions) {
        return this.mapVocabularyByIdExecutor.map(context, entityIds);
    }

    @Override
    protected void checkAccess(IOperationContext context, IVocabularyId entityId, VocabularyPE entity) {
        this.authorizationExecutor.canDelete(context, entityId, entity);
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, VocabularyPE entity) {
    }

    @Override
    protected Void delete(IOperationContext context, Collection<VocabularyPE> vocabularies, VocabularyDeletionOptions deletionOptions) {
        IVocabularyBO vocabularyBO = this.businessObjectFactory.createVocabularyBO(context.getSession());
        String reason = deletionOptions.getReason();
        for (VocabularyPE vocabulary : vocabularies) {
            vocabularyBO.deleteByTechId(new TechId(vocabulary.getId()), reason);
        }
        return null;
    }
}

