/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.delete.VocabularyTermDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.IVocabularyTermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IDeleteVocabularyTermExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IMapVocabularyTermByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IVocabularyTermAuthorizationExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IVocabularyBO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermReplacement;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteVocabularyTermExecutor
extends AbstractDeleteEntityExecutor<Void, IVocabularyTermId, VocabularyTermPE, VocabularyTermDeletionOptions>
implements IDeleteVocabularyTermExecutor {
    @Autowired
    private IVocabularyTermAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IMapVocabularyTermByIdExecutor mapTermByIdExecutor;

    @Override
    protected Map<IVocabularyTermId, VocabularyTermPE> map(IOperationContext context, List<? extends IVocabularyTermId> entityIds, VocabularyTermDeletionOptions deletionOptions) {
        return this.mapTermByIdExecutor.map(context, entityIds);
    }

    @Override
    protected void checkAccess(IOperationContext context, IVocabularyTermId entityId, VocabularyTermPE entity) {
        this.authorizationExecutor.canDelete(context);
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, VocabularyTermPE entity) {
    }

    @Override
    protected Void delete(IOperationContext context, Collection<VocabularyTermPE> terms, VocabularyTermDeletionOptions deletionOptions) {
        Map<VocabularyTermPE, VocabularyTermPE> replacementMap = this.getReplacementMap(context, deletionOptions);
        HashMap<VocabularyPE, ArrayList<VocabularyTerm>> termsToBeDeletedMap = new HashMap<VocabularyPE, ArrayList<VocabularyTerm>>();
        HashMap<VocabularyPE, ArrayList<VocabularyTermReplacement>> termsToBeReplacedMap = new HashMap<VocabularyPE, ArrayList<VocabularyTermReplacement>>();
        for (VocabularyTermPE term : terms) {
            if (replacementMap.get(term) == null) {
                ArrayList<VocabularyTerm> termsToBeDeleted = (ArrayList<VocabularyTerm>)termsToBeDeletedMap.get(term.getVocabulary());
                if (termsToBeDeleted == null) {
                    termsToBeDeleted = new ArrayList<VocabularyTerm>();
                    termsToBeDeletedMap.put(term.getVocabulary(), termsToBeDeleted);
                }
                termsToBeDeleted.add(this.createDeleted(term.getCode()));
                continue;
            }
            ArrayList<VocabularyTermReplacement> termsToBeReplaced = (ArrayList<VocabularyTermReplacement>)termsToBeReplacedMap.get(term.getVocabulary());
            if (termsToBeReplaced == null) {
                termsToBeReplaced = new ArrayList<VocabularyTermReplacement>();
                termsToBeReplacedMap.put(term.getVocabulary(), termsToBeReplaced);
            }
            termsToBeReplaced.add(this.createReplaced(term, replacementMap.get(term).getCode()));
        }
        HashSet<VocabularyTermPE> unmatchedReplacements = new HashSet<VocabularyTermPE>(replacementMap.keySet());
        unmatchedReplacements.removeAll(terms);
        if (unmatchedReplacements.size() > 0) {
            throw new UserFailureException("The following terms where not chosen to be deleted but had replacements specified: " + unmatchedReplacements + ".");
        }
        HashSet vocabularies = new HashSet();
        vocabularies.addAll(termsToBeDeletedMap.keySet());
        vocabularies.addAll(termsToBeReplacedMap.keySet());
        for (VocabularyPE vocabulary : vocabularies) {
            List<VocabularyTerm> termsToBeDeleted = (List<VocabularyTerm>)termsToBeDeletedMap.get(vocabulary);
            List<VocabularyTermReplacement> termsToBeReplaced = (List<VocabularyTermReplacement>)termsToBeReplacedMap.get(vocabulary);
            if (termsToBeDeleted == null) {
                termsToBeDeleted = Collections.emptyList();
            }
            if (termsToBeReplaced == null) {
                termsToBeReplaced = Collections.emptyList();
            }
            IVocabularyBO vocabularyBO = this.businessObjectFactory.createVocabularyBO(context.getSession());
            vocabularyBO.loadDataByTechId(new TechId(vocabulary.getId()));
            vocabularyBO.delete(termsToBeDeleted, termsToBeReplaced);
            vocabularyBO.save();
        }
        return null;
    }

    private Map<VocabularyTermPE, VocabularyTermPE> getReplacementMap(IOperationContext context, VocabularyTermDeletionOptions deletionOptions) {
        HashSet<IVocabularyTermId> termIds = new HashSet<IVocabularyTermId>();
        for (ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.delete.VocabularyTermReplacement replacement : deletionOptions.getReplacements()) {
            termIds.add(replacement.getReplacedId());
            termIds.add(replacement.getReplacementId());
        }
        Map termMap = this.mapTermByIdExecutor.map(context, termIds);
        HashMap<VocabularyTermPE, VocabularyTermPE> replacementMap = new HashMap<VocabularyTermPE, VocabularyTermPE>();
        for (ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.delete.VocabularyTermReplacement replacement : deletionOptions.getReplacements()) {
            VocabularyTermPE replacedPE = (VocabularyTermPE)termMap.get(replacement.getReplacedId());
            VocabularyTermPE replacementPE = (VocabularyTermPE)termMap.get(replacement.getReplacementId());
            if (replacedPE != null && replacementPE != null) {
                if (!replacedPE.getVocabulary().equals(replacementPE.getVocabulary())) {
                    throw new UserFailureException("Replaced " + replacement.getReplacedId() + " and replacement " + replacement.getReplacementId() + " terms cannot belong to different vocabularies.");
                }
                replacementMap.put(replacedPE, replacementPE);
                continue;
            }
            if (replacementPE != null) continue;
            throw new UserFailureException("Replacement term " + replacement.getReplacementId() + " does not exist.");
        }
        return replacementMap;
    }

    private VocabularyTermReplacement createReplaced(VocabularyTermPE term, String replacementCode) {
        VocabularyTerm replaced = new VocabularyTerm();
        replaced.setCode(term.getCode());
        replaced.setId(term.getId());
        VocabularyTermReplacement replacement = new VocabularyTermReplacement();
        replacement.setTerm(replaced);
        replacement.setReplacementCode(replacementCode);
        return replacement;
    }

    private VocabularyTerm createDeleted(String code) {
        VocabularyTerm deleted = new VocabularyTerm();
        deleted.setCode(code);
        return deleted;
    }
}

