/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.VocabularyPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.search.VocabularySearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodeMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodesMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.ISearchVocabularyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IVocabularyAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchVocabularyExecutor
extends AbstractSearchObjectManuallyExecutor<VocabularySearchCriteria, VocabularyPE>
implements ISearchVocabularyExecutor {
    @Autowired
    private IVocabularyAuthorizationExecutor authorizationExecutor;

    @Override
    public List<VocabularyPE> search(IOperationContext context, VocabularySearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<VocabularyPE> listAll() {
        return this.daoFactory.getVocabularyDAO().listAllEntities();
    }

    @Override
    protected Matcher<VocabularyPE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof CodeSearchCriteria || criteria instanceof PermIdSearchCriteria) {
            return new CodeMatcher<VocabularyPE>();
        }
        if (criteria instanceof CodesSearchCriteria) {
            return new CodesMatcher<VocabularyPE>();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class IdMatcher
    extends SimpleFieldMatcher<VocabularyPE> {
        private IdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, VocabularyPE object, ISearchCriteria criteria) {
            IObjectId id = ((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof VocabularyPermId) {
                VocabularyPermId permId = (VocabularyPermId)id;
                return object.getCode().equals(permId.getPermId());
            }
            throw new IllegalArgumentException("Unknown id: " + id.getClass());
        }
    }
}

