/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.VocabularyTermPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.search.VocabularySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.search.VocabularyTermSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodeMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodesMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.StringFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.ISearchVocabularyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.ISearchVocabularyTermExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IVocabularyTermAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchVocabularyTermExecutor
extends AbstractSearchObjectManuallyExecutor<VocabularyTermSearchCriteria, VocabularyTermPE>
implements ISearchVocabularyTermExecutor {
    @Autowired
    private ISearchVocabularyExecutor searchVocabularyExecutor;
    @Autowired
    private IVocabularyTermAuthorizationExecutor authorizationExecutor;

    @Override
    public List<VocabularyTermPE> search(IOperationContext context, VocabularyTermSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<VocabularyTermPE> listAll() {
        return this.daoFactory.getVocabularyTermDAO().listAllEntities();
    }

    @Override
    protected Matcher<VocabularyTermPE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof PermIdSearchCriteria) {
            return new PermIdMatcher();
        }
        if (criteria instanceof CodeSearchCriteria) {
            return new CodeMatcher<VocabularyTermPE>();
        }
        if (criteria instanceof CodesSearchCriteria) {
            return new CodesMatcher<VocabularyTermPE>();
        }
        if (criteria instanceof VocabularySearchCriteria) {
            return new VocabularyMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class VocabularyMatcher
    extends Matcher<VocabularyTermPE> {
        private VocabularyMatcher() {
        }

        @Override
        public List<VocabularyTermPE> getMatching(IOperationContext context, List<VocabularyTermPE> objects, ISearchCriteria criteria) {
            List vocabularyList = SearchVocabularyTermExecutor.this.searchVocabularyExecutor.search(context, (VocabularySearchCriteria)criteria);
            HashSet vocabularySet = new HashSet(vocabularyList);
            ArrayList<VocabularyTermPE> matches = new ArrayList<VocabularyTermPE>();
            for (VocabularyTermPE object : objects) {
                if (!vocabularySet.contains(object.getVocabulary())) continue;
                matches.add(object);
            }
            return matches;
        }
    }

    private class PermIdMatcher
    extends StringFieldMatcher<VocabularyTermPE> {
        private PermIdMatcher() {
        }

        @Override
        protected String getFieldValue(VocabularyTermPE object) {
            return new VocabularyTermPermId(object.getCode(), object.getVocabulary().getCode()).toString();
        }
    }

    private class IdMatcher
    extends SimpleFieldMatcher<VocabularyTermPE> {
        private IdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, VocabularyTermPE object, ISearchCriteria criteria) {
            IObjectId id = ((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof VocabularyTermPermId) {
                VocabularyTermPermId permId = (VocabularyTermPermId)id;
                return object.getCode().equals(permId.getCode()) && object.getVocabulary().getCode().equals(permId.getVocabularyCode());
            }
            throw new IllegalArgumentException("Unknown id: " + id.getClass());
        }
    }
}

