/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.IVocabularyId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.VocabularyPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.update.VocabularyUpdate;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IMapVocabularyByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IUpdateVocabularyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IVocabularyAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class UpdateVocabularyExecutor
extends AbstractUpdateEntityExecutor<VocabularyUpdate, VocabularyPE, IVocabularyId, VocabularyPermId>
implements IUpdateVocabularyExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapVocabularyByIdExecutor mapVocabularyByIdExecutor;
    @Autowired
    private IVocabularyAuthorizationExecutor authorizationExecutor;

    @Override
    protected IVocabularyId getId(VocabularyUpdate update) {
        return update.getVocabularyId();
    }

    @Override
    protected VocabularyPermId getPermId(VocabularyPE entity) {
        return new VocabularyPermId(entity.getPermId());
    }

    @Override
    protected void checkData(IOperationContext context, VocabularyUpdate update) {
        if (update.getVocabularyId() == null) {
            throw new UserFailureException("Vocabulary id cannot be null.");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context, IVocabularyId id, VocabularyPE entity) {
        this.authorizationExecutor.canUpdate(context, id, entity);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<VocabularyUpdate, VocabularyPE> batch) {
        Set entrySet = ((Map)batch.getObjects()).entrySet();
        for (Map.Entry entry : entrySet) {
            VocabularyUpdate update = (VocabularyUpdate)entry.getKey();
            VocabularyPE vocabulary = (VocabularyPE)entry.getValue();
            vocabulary.setDescription(this.getNewValue(update.getDescription(), vocabulary.getDescription()));
            vocabulary.setChosenFromList(this.getNewValue(update.getChosenFromList(), vocabulary.isChosenFromList()));
            vocabulary.setURLTemplate(this.getNewValue(update.getUrlTemplate(), vocabulary.getURLTemplate()));
        }
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<VocabularyUpdate, VocabularyPE> batch) {
    }

    @Override
    protected Map<IVocabularyId, VocabularyPE> map(IOperationContext context, Collection<IVocabularyId> ids) {
        return this.mapVocabularyByIdExecutor.map(context, ids);
    }

    @Override
    protected List<VocabularyPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getVocabularyDAO().listAllEntities();
    }

    @Override
    protected void save(IOperationContext context, List<VocabularyPE> entities, boolean clearCache) {
        for (VocabularyPE vocabulary : entities) {
            this.daoFactory.getVocabularyDAO().validateAndSaveUpdatedEntity(vocabulary);
        }
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "vocabulary", null);
    }
}

