/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.IVocabularyTermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.VocabularyTermPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.update.VocabularyTermUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IMapVocabularyTermByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IUpdateVocabularyTermExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IVocabularyTermAuthorizationExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IVocabularyTermBO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IVocabularyTermUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateVocabularyTermExecutor
implements IUpdateVocabularyTermExecutor {
    @Resource(name="common-business-object-factory")
    private ICommonBusinessObjectFactory businessObjectFactory;
    @Autowired
    private IMapVocabularyTermByIdExecutor mapVocabularyTermByIdExecutor;
    @Autowired
    private IVocabularyTermAuthorizationExecutor authorizationExecutor;

    @Override
    public List<VocabularyTermPermId> update(IOperationContext context, List<VocabularyTermUpdate> updates) {
        this.authorizationExecutor.canUpdate(context);
        this.checkData(context, updates);
        Map<IVocabularyTermId, VocabularyTermPE> terms = this.getTermsMap(context, updates);
        final Map<IVocabularyTermId, VocabularyTermPE> previousTerms = this.getPreviousTermsMap(context, updates);
        IVocabularyTermBO termBO = this.businessObjectFactory.createVocabularyTermBO(context.getSession());
        ArrayList<VocabularyTermPermId> permIds = new ArrayList<VocabularyTermPermId>();
        for (final VocabularyTermUpdate update : updates) {
            final VocabularyTermPE termPE = terms.get(update.getVocabularyTermId());
            permIds.add(new VocabularyTermPermId(termPE.getCode(), termPE.getVocabulary().getCode()));
            if (update.getDescription().isModified() || update.getLabel().isModified() || update.getPreviousTermId().isModified()) {
                termBO.update(new IVocabularyTermUpdates(){

                    public Long getId() {
                        return termPE.getId();
                    }

                    public String getCode() {
                        return termPE.getCode();
                    }

                    public String getLabel() {
                        return update.getLabel().isModified() ? (String)update.getLabel().getValue() : termPE.getLabel();
                    }

                    public String getDescription() {
                        return update.getDescription().isModified() ? (String)update.getDescription().getValue() : termPE.getDescription();
                    }

                    public Long getOrdinal() {
                        if (update.getPreviousTermId().isModified()) {
                            if (update.getPreviousTermId().getValue() == null) {
                                Long minOrdinal = termPE.getOrdinal();
                                for (VocabularyTermPE otherTermPE : termPE.getVocabulary().getTerms()) {
                                    if (minOrdinal <= otherTermPE.getOrdinal()) continue;
                                    minOrdinal = otherTermPE.getOrdinal();
                                }
                                return minOrdinal;
                            }
                            VocabularyTermPE previousTermPE = (VocabularyTermPE)previousTerms.get(update.getPreviousTermId().getValue());
                            if (!previousTermPE.getVocabulary().equals(termPE.getVocabulary())) {
                                throw new UserFailureException("Position of term " + update.getVocabularyTermId() + " could not be found as the specified previous term " + update.getPreviousTermId().getValue() + " is in a different vocabulary (" + previousTermPE.getVocabulary().getCode() + ").");
                            }
                            return previousTermPE.getOrdinal() + 1L;
                        }
                        return termPE.getOrdinal();
                    }

                    public Date getModificationDate() {
                        return termPE.getModificationDate();
                    }
                });
            }
            if (!update.isOfficial().isModified()) continue;
            if (termPE.isOfficial().booleanValue() && Boolean.FALSE.equals(update.isOfficial().getValue())) {
                throw new UserFailureException("Offical vocabulary term " + update.getVocabularyTermId() + " cannot be updated to be unofficial.");
            }
            VocabularyTerm term = new VocabularyTerm();
            term.setId(termPE.getId());
            termBO.makeOfficial(Arrays.asList(term));
        }
        return permIds;
    }

    private void checkData(IOperationContext context, Collection<VocabularyTermUpdate> updates) {
        for (VocabularyTermUpdate update : updates) {
            if (update.getVocabularyTermId() != null) continue;
            throw new UserFailureException("Vocabulary term id cannot be null");
        }
    }

    private Map<IVocabularyTermId, VocabularyTermPE> getTermsMap(IOperationContext context, List<VocabularyTermUpdate> updates) {
        HashSet<IVocabularyTermId> ids = new HashSet<IVocabularyTermId>();
        for (VocabularyTermUpdate update : updates) {
            ids.add(update.getVocabularyTermId());
        }
        Map<IVocabularyTermId, VocabularyTermPE> termsMap = this.mapVocabularyTermByIdExecutor.map(context, ids);
        for (IVocabularyTermId id : ids) {
            if (termsMap.get(id) != null) continue;
            throw new ObjectNotFoundException((IObjectId)id);
        }
        return termsMap;
    }

    private Map<IVocabularyTermId, VocabularyTermPE> getPreviousTermsMap(IOperationContext context, List<VocabularyTermUpdate> updates) {
        HashSet<IVocabularyTermId> ids = new HashSet<IVocabularyTermId>();
        for (VocabularyTermUpdate update : updates) {
            if (update.getPreviousTermId().getValue() == null) continue;
            ids.add((IVocabularyTermId)update.getPreviousTermId().getValue());
        }
        Map<IVocabularyTermId, VocabularyTermPE> termsMap = this.mapVocabularyTermByIdExecutor.map(context, ids);
        for (IVocabularyTermId id : ids) {
            if (termsMap.get(id) != null) continue;
            throw new ObjectNotFoundException((IObjectId)id);
        }
        return termsMap;
    }
}

