/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.IVocabularyId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IVocabularyAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.business.bo.InternalVocabularyAuthorization;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseCreateOrDeleteModification;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseUpdateModification;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import org.springframework.stereotype.Component;

@Component
public class VocabularyAuthorizationExecutor
implements IVocabularyAuthorizationExecutor {
    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN, RoleWithHierarchy.INSTANCE_ETL_SERVER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY})
    @Capability(value="CREATE_VOCABULARY")
    public void canCreate(IOperationContext context, VocabularyPE entity) {
        new InternalVocabularyAuthorization().canCreateVocabulary(context.getSession(), entity);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="GET_VOCABULARY")
    public void canGet(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="SEARCH_VOCABULARY")
    public void canSearch(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN, RoleWithHierarchy.INSTANCE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY})
    @Capability(value="UPDATE_VOCABULARY")
    public void canUpdate(IOperationContext context, IVocabularyId id, VocabularyPE entity) {
        new InternalVocabularyAuthorization().canUpdateVocabulary(context.getSession(), entity);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN, RoleWithHierarchy.INSTANCE_ETL_SERVER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY})
    @Capability(value="DELETE_VOCABULARY")
    public void canDelete(IOperationContext context, IVocabularyId entityId, VocabularyPE entity) {
        new InternalVocabularyAuthorization().canDeleteVocabulary(context.getSession(), entity);
    }
}

