/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommonUtils {
    public static Set<Long> asSet(Collection<Long> ids) {
        return ids instanceof Set ? (Set<Object>)ids : new HashSet<Long>(ids);
    }

    public static List<PersonPE> listPersons(IDAOFactory daoFactory, Collection<Long> ids) {
        Set<Long> idSet = CommonUtils.asSet(ids);
        ArrayList<PersonPE> result = new ArrayList<PersonPE>();
        List<PersonPE> persons = daoFactory.getPersonDAO().listPersons();
        for (PersonPE person : persons) {
            if (!idSet.contains(person.getId())) continue;
            result.add(person);
        }
        return result;
    }

    public static Map<String, String> asMap(String json) {
        if (json == null) {
            return new HashMap<String, String>();
        }
        try {
            return (Map)new ObjectMapper().readValue(json.getBytes("UTF-8"), HashMap.class);
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }
}

