/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.CreationId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import java.util.HashMap;
import java.util.Map;

public class CreationIdCache {
    private Map<CreationId, IObjectId> creationIdToRealIdMap = new HashMap<CreationId, IObjectId>();
    private Map<IObjectId, CreationId> realIdToCreationIdMap = new HashMap<IObjectId, CreationId>();

    public void putIds(CreationId creationId, IObjectId realId) {
        this.creationIdToRealIdMap.put(creationId, realId);
        this.realIdToCreationIdMap.put(realId, creationId);
    }

    public IObjectId getRealId(CreationId creationId) {
        return this.creationIdToRealIdMap.get(creationId);
    }

    public CreationId getCreationId(IObjectId realId) {
        return this.realIdToCreationIdMap.get(realId);
    }

    public static CreationIdCache getInstance(IOperationContext context) {
        CreationIdCache cache = (CreationIdCache)context.getAttribute(CreationIdCache.class.getName());
        if (cache == null) {
            cache = new CreationIdCache();
            context.setAttribute(CreationIdCache.class.getName(), cache);
        }
        return cache;
    }
}

