/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnsupportedObjectIdException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.IListObjectById;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MapObjectById<ID, OBJECT> {
    private Map<Class, List> groupIdsByClass(Collection ids) {
        HashMap<Class, List> idClassToIdListMap = new HashMap<Class, List>();
        for (Object id : ids) {
            if (id == null) continue;
            LinkedList idList = (LinkedList)idClassToIdListMap.get(id.getClass());
            if (idList == null) {
                idList = new LinkedList();
                idClassToIdListMap.put(id.getClass(), idList);
            }
            idList.add(id);
        }
        return idClassToIdListMap;
    }

    private Map mapByIds(IOperationContext context, List<IListObjectById<? extends ID, OBJECT>> listers, Map<Class, List> idClassToIdListMap) {
        HashMap idToObject = new HashMap();
        for (Class idClass : idClassToIdListMap.keySet()) {
            List idList;
            IListObjectById listerForIdClass = this.findLister(listers, idClass, idList = idClassToIdListMap.get(idClass));
            List objects = listerForIdClass.listByIds(context, idList);
            if (objects == null) continue;
            for (Object object : objects) {
                Object createId = listerForIdClass.createId(object);
                idToObject.put(createId, object);
            }
        }
        return idToObject;
    }

    private IListObjectById findLister(List<IListObjectById<? extends ID, OBJECT>> listers, Class idClass, List idList) {
        for (IListObjectById<ID, OBJECT> lister : listers) {
            if (!lister.acceptsIdClass(idClass)) continue;
            return lister;
        }
        throw new UnsupportedObjectIdException((IObjectId)idList.iterator().next());
    }

    public Map<ID, OBJECT> map(IOperationContext context, List<IListObjectById<? extends ID, OBJECT>> listers, Collection<? extends ID> ids) {
        Map<Class, List> idClassToIdListMap = this.groupIdsByClass(ids);
        Map idToObjectMap = this.mapByIds(context, listers, idClassToIdListMap);
        LinkedHashMap orderedMap = new LinkedHashMap();
        for (ID id : ids) {
            Object object = idToObjectMap.get(id);
            if (object == null) continue;
            orderedMap.put(id, object);
        }
        return orderedMap;
    }
}

