/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch;

import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public abstract class Batch<B> {
    public static final int DEFAULT_BATCH_SIZE = 1000;
    private int batchIndex;
    private int fromObjectIndex;
    private int toObjectIndex;
    private B objects;
    private int totalObjectCount;

    public Batch(int batchIndex, int fromObjectIndex, int toObjectIndex, B objects, int totalObjectCount) {
        this.batchIndex = batchIndex;
        this.fromObjectIndex = fromObjectIndex;
        this.toObjectIndex = toObjectIndex;
        this.objects = objects;
        this.totalObjectCount = totalObjectCount;
    }

    public int getBatchIndex() {
        return this.batchIndex;
    }

    public int getFromObjectIndex() {
        return this.fromObjectIndex;
    }

    public int getToObjectIndex() {
        return this.toObjectIndex;
    }

    public B getObjects() {
        return this.objects;
    }

    public int getTotalObjectCount() {
        return this.totalObjectCount;
    }

    public static <T> Collection<CollectionBatch<T>> createBatches(Collection<T> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<CollectionBatch<T>> batches = new LinkedList<CollectionBatch<T>>();
        Iterator<T> iterator = objects.iterator();
        int batchIndex = 0;
        int batchSize = 1000;
        for (int batchStart = 0; batchStart < objects.size(); batchStart += batchSize) {
            int batchFinish = Math.min(batchStart + batchSize, objects.size());
            ArrayList<T> batchObjects = new ArrayList<T>(batchSize);
            for (int objectIndex = batchStart; objectIndex < batchFinish; ++objectIndex) {
                batchObjects.add(iterator.next());
            }
            CollectionBatch batch = new CollectionBatch(batchIndex, batchStart, batchFinish, batchObjects, objects.size());
            batches.add(batch);
            ++batchIndex;
        }
        return batches;
    }

    public static <K, V> Collection<MapBatch<K, V>> createBatches(Map<K, V> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<MapBatch<K, V>> batches = new LinkedList<MapBatch<K, V>>();
        Iterator<Map.Entry<K, V>> iterator = objects.entrySet().iterator();
        int batchIndex = 0;
        int batchSize = 1000;
        for (int batchStart = 0; batchStart < objects.size(); batchStart += batchSize) {
            int batchFinish = Math.min(batchStart + batchSize, objects.size());
            HashMap<K, V> batchObjects = new HashMap<K, V>(batchSize);
            for (int objectIndex = batchStart; objectIndex < batchFinish; ++objectIndex) {
                Map.Entry<K, V> entry = iterator.next();
                batchObjects.put(entry.getKey(), entry.getValue());
            }
            MapBatch batch = new MapBatch(batchIndex, batchStart, batchFinish, batchObjects, objects.size());
            batches.add(batch);
            ++batchIndex;
        }
        return batches;
    }
}

