/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch;

import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import java.util.Collection;

public abstract class CollectionBatchProcessor<T> {
    public abstract void process(T var1);

    public abstract IProgress createProgress(T var1, int var2, int var3);

    public CollectionBatchProcessor(IOperationContext context, CollectionBatch<? extends T> batch) {
        int objectIndex = batch.getFromObjectIndex() + 1;
        int totalObjectCount = batch.getTotalObjectCount();
        for (Object object : (Collection)batch.getObjects()) {
            IProgress progress = this.createProgress(object, objectIndex, totalObjectCount);
            context.pushProgress(progress);
            this.process(object);
            context.popProgress();
            ++objectIndex;
        }
    }
}

