/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch;

import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import java.util.Map;

public abstract class MapBatchProcessor<K, V> {
    public abstract void process(K var1, V var2);

    public abstract IProgress createProgress(K var1, V var2, int var3, int var4);

    public MapBatchProcessor(IOperationContext context, MapBatch<K, V> batch) {
        int objectIndex = batch.getFromObjectIndex() + 1;
        int totalObjectCount = batch.getTotalObjectCount();
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            IProgress progress = this.createProgress(entry.getKey(), entry.getValue(), objectIndex, totalObjectCount);
            context.pushProgress(progress);
            this.process(entry.getKey(), entry.getValue());
            context.popProgress();
            ++objectIndex;
        }
    }
}

