/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.LocatorTypePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.AbstractListObjectById;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ILocatorTypeDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.LocatorTypePE;
import java.util.ArrayList;
import java.util.List;

public class ListLocatorTypeByPermId
extends AbstractListObjectById<LocatorTypePermId, LocatorTypePE> {
    private ILocatorTypeDAO typeDAO;

    public ListLocatorTypeByPermId(ILocatorTypeDAO typeDAO) {
        this.typeDAO = typeDAO;
    }

    @Override
    public Class<LocatorTypePermId> getIdClass() {
        return LocatorTypePermId.class;
    }

    @Override
    public LocatorTypePermId createId(LocatorTypePE type) {
        return new LocatorTypePermId(type.getCode());
    }

    @Override
    public List<LocatorTypePE> listByIds(IOperationContext context, List<LocatorTypePermId> ids) {
        ArrayList<LocatorTypePE> types = new ArrayList<LocatorTypePE>();
        for (LocatorTypePermId id : ids) {
            LocatorTypePE type = this.typeDAO.tryToFindLocatorTypeByCode(id.getPermId());
            if (type == null) continue;
            types.add(type);
        }
        return types;
    }
}

