/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.datastore;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.DataStorePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.AbstractListObjectById;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataStoreDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import java.util.LinkedList;
import java.util.List;

public class ListDataStoreByPermId
extends AbstractListObjectById<DataStorePermId, DataStorePE> {
    private IDataStoreDAO dataStoreDAO;

    public ListDataStoreByPermId(IDataStoreDAO dataStoreDAO) {
        this.dataStoreDAO = dataStoreDAO;
    }

    @Override
    public Class<DataStorePermId> getIdClass() {
        return DataStorePermId.class;
    }

    @Override
    public DataStorePermId createId(DataStorePE dataStore) {
        return new DataStorePermId(dataStore.getCode());
    }

    @Override
    public List<DataStorePE> listByIds(IOperationContext context, List<DataStorePermId> ids) {
        LinkedList<DataStorePE> dataStores = new LinkedList<DataStorePE>();
        for (DataStorePermId id : ids) {
            DataStorePE dataStore = this.dataStoreDAO.tryToFindDataStoreByCode(id.getPermId());
            if (dataStore == null) continue;
            dataStores.add(dataStore);
        }
        return dataStores;
    }
}

