/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.AbstractListObjectById;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.EntityKindConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ListEntityTypeByPermId
extends AbstractListObjectById<EntityTypePermId, EntityTypePE> {
    private IDAOFactory daoFactory;

    public ListEntityTypeByPermId(IDAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public Class<EntityTypePermId> getIdClass() {
        return EntityTypePermId.class;
    }

    @Override
    public EntityTypePermId createId(EntityTypePE entityType) {
        return new EntityTypePermId(entityType.getPermId(), EntityKindConverter.convert(entityType.getEntityKind()));
    }

    @Override
    public List<EntityTypePE> listByIds(IOperationContext context, List<EntityTypePermId> ids) {
        ArrayList<EntityTypePermId> materialTypeIds = new ArrayList<EntityTypePermId>();
        ArrayList<EntityTypePermId> experimentTypeIds = new ArrayList<EntityTypePermId>();
        ArrayList<EntityTypePermId> sampleTypeIds = new ArrayList<EntityTypePermId>();
        ArrayList<EntityTypePermId> dataSetTypeIds = new ArrayList<EntityTypePermId>();
        for (EntityTypePermId id : ids) {
            EntityKind entityKind = EntityKindConverter.convert(id.getEntityKind());
            if (EntityKind.MATERIAL.equals((Object)entityKind)) {
                materialTypeIds.add(id);
                continue;
            }
            if (EntityKind.EXPERIMENT.equals((Object)entityKind)) {
                experimentTypeIds.add(id);
                continue;
            }
            if (EntityKind.SAMPLE.equals((Object)entityKind)) {
                sampleTypeIds.add(id);
                continue;
            }
            if (!EntityKind.DATA_SET.equals((Object)entityKind)) continue;
            dataSetTypeIds.add(id);
        }
        ArrayList<EntityTypePE> results = new ArrayList<EntityTypePE>();
        results.addAll(this.listByIds(context, materialTypeIds, EntityKind.MATERIAL));
        results.addAll(this.listByIds(context, experimentTypeIds, EntityKind.EXPERIMENT));
        results.addAll(this.listByIds(context, sampleTypeIds, EntityKind.SAMPLE));
        results.addAll(this.listByIds(context, dataSetTypeIds, EntityKind.DATA_SET));
        return results;
    }

    private List<EntityTypePE> listByIds(IOperationContext context, List<EntityTypePermId> ids, EntityKind entityKind) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        IEntityTypeDAO entityTypeDAO = this.daoFactory.getEntityTypeDAO(entityKind);
        LinkedList<String> permIds = new LinkedList<String>();
        for (EntityTypePermId id : ids) {
            permIds.add(id.getPermId());
        }
        return entityTypeDAO.tryToFindEntityTypeByCodes(permIds);
    }
}

