/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress;

import ch.ethz.sis.openbis.generic.server.asapi.v3.context.Progress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.ProgressDetails;
import ch.systemsx.cisd.common.action.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IPermIdHolder;

public class EntityProgress
extends Progress {
    private static final long serialVersionUID = 1L;
    private IIdHolder entity;

    public EntityProgress(String label, IIdHolder entity, int numItemsProcessed, int totalItemsToProcess) {
        super(label, numItemsProcessed, totalItemsToProcess);
        this.entity = entity;
    }

    @Override
    protected void updateDetails(ProgressDetails details) {
        if (this.entity != null) {
            final ProgressDetails entityDetails = new ProgressDetails();
            entityDetails.set("class", this.entity.getClass().getSimpleName());
            this.setWithFailureAllowed(new IDelegatedAction(){

                public void execute() {
                    entityDetails.set("id", EntityProgress.this.entity.getId());
                }
            });
            this.setWithFailureAllowed(new IDelegatedAction(){

                public void execute() {
                    if (EntityProgress.this.entity instanceof IPermIdHolder) {
                        entityDetails.set("permId", ((IPermIdHolder)EntityProgress.this.entity).getPermId());
                    }
                }
            });
            this.setWithFailureAllowed(new IDelegatedAction(){

                public void execute() {
                    if (EntityProgress.this.entity instanceof IIdentityHolder) {
                        entityDetails.set("identifier", ((IIdentityHolder)EntityProgress.this.entity).getIdentifier());
                    }
                }
            });
            details.set("entity", entityDetails);
        }
    }

    private void setWithFailureAllowed(IDelegatedAction setAction) {
        try {
            setAction.execute();
        }
        catch (Exception exception) {
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }
}

