/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.experiment;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.AbstractListObjectById;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IProjectDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ListExperimentByIdentifier
extends AbstractListObjectById<ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier, ExperimentPE> {
    private IProjectDAO projectDAO;
    private IExperimentDAO experimentDAO;

    public ListExperimentByIdentifier(IProjectDAO projectDAO, IExperimentDAO experimentDAO) {
        this.projectDAO = projectDAO;
        this.experimentDAO = experimentDAO;
    }

    @Override
    public Class<ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier> getIdClass() {
        return ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier.class;
    }

    @Override
    public ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier createId(ExperimentPE experiment) {
        return new ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier(experiment.getIdentifier());
    }

    @Override
    public List<ExperimentPE> listByIds(IOperationContext context, List<ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier> experimentIdentifiers) {
        LinkedList<ExperimentPE> experiments = new LinkedList<ExperimentPE>();
        Map<ProjectPE, List<String>> projectToExperimentCodesMap = this.getProjectToExperimentCodesMap(experimentIdentifiers);
        for (Map.Entry<ProjectPE, List<String>> entry : projectToExperimentCodesMap.entrySet()) {
            List<ExperimentPE> projectExperiments = this.experimentDAO.listByProjectAndCodes(entry.getKey(), (Collection<String>)entry.getValue());
            experiments.addAll(projectExperiments);
        }
        return experiments;
    }

    private Map<ProjectPE, List<String>> getProjectToExperimentCodesMap(List<ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier> experimentIdentifiers) {
        HashMap<ProjectIdentifier, ProjectPE> projectIdentifierToProjectMap = new HashMap<ProjectIdentifier, ProjectPE>();
        HashMap<ProjectPE, List<String>> projectToExperimentCodesMap = new HashMap<ProjectPE, List<String>>();
        for (ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier experimentIdentifier : experimentIdentifiers) {
            ExperimentIdentifier coreExperimentIdentifier = ExperimentIdentifierFactory.parse(experimentIdentifier.getIdentifier());
            ProjectIdentifier coreProjectIdentifier = new ProjectIdentifier(coreExperimentIdentifier.getSpaceCode(), coreExperimentIdentifier.getProjectCode());
            ProjectPE project = null;
            if (projectIdentifierToProjectMap.containsKey(coreProjectIdentifier)) {
                project = (ProjectPE)projectIdentifierToProjectMap.get(coreProjectIdentifier);
            } else {
                project = this.projectDAO.tryFindProject(coreProjectIdentifier.getSpaceCode(), coreProjectIdentifier.getProjectCode());
                projectIdentifierToProjectMap.put(coreProjectIdentifier, project);
            }
            if (project == null) continue;
            LinkedList<String> experimentCodes = (LinkedList<String>)projectToExperimentCodesMap.get(project);
            if (experimentCodes == null) {
                experimentCodes = new LinkedList<String>();
                projectToExperimentCodesMap.put(project, experimentCodes);
            }
            experimentCodes.add(coreExperimentIdentifier.getExperimentCode());
        }
        return projectToExperimentCodesMap;
    }
}

