/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.externaldms;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.id.ExternalDmsPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.AbstractListObjectById;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExternalDataManagementSystemDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataManagementSystemPE;
import java.util.LinkedList;
import java.util.List;

public class ListExternalDmsByPermId
extends AbstractListObjectById<ExternalDmsPermId, ExternalDataManagementSystemPE> {
    private IExternalDataManagementSystemDAO externalDmsDAO;

    public ListExternalDmsByPermId(IExternalDataManagementSystemDAO externalDmsDAO) {
        this.externalDmsDAO = externalDmsDAO;
    }

    @Override
    public Class<ExternalDmsPermId> getIdClass() {
        return ExternalDmsPermId.class;
    }

    @Override
    public ExternalDmsPermId createId(ExternalDataManagementSystemPE externalDms) {
        return new ExternalDmsPermId(externalDms.getCode());
    }

    @Override
    public List<ExternalDataManagementSystemPE> listByIds(IOperationContext context, List<ExternalDmsPermId> ids) {
        LinkedList<ExternalDataManagementSystemPE> externalDmses = new LinkedList<ExternalDataManagementSystemPE>();
        for (ExternalDmsPermId id : ids) {
            ExternalDataManagementSystemPE externalDms = this.externalDmsDAO.tryToFindExternalDataManagementSystemByCode(id.getPermId());
            if (externalDms == null) continue;
            externalDmses.add(externalDms);
        }
        return externalDmses;
    }
}

