/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.generators;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.BeanUtils;

public class DtoGenerator {
    private static final String PACKAGE_PREFIX = "ch.ethz.sis.openbis.generic.asapi.v3.dto";
    private int indent = 0;
    List<DTOField> fields;
    private String subPackage;
    private String className;
    private Set<String> additionalImports;
    private List<String> additionalMethods;
    private PrintStream outputStream = System.out;
    private Class<?> fetchOptionsClass;
    private String toStringContent;
    private Set<String> implementedInterfaces;
    private boolean deprecated;

    public DtoGenerator(String subPackage, String className, Class<?> fetchOptionsClass) {
        this.subPackage = subPackage;
        this.className = className;
        this.additionalImports = new TreeSet<String>();
        this.additionalMethods = new LinkedList<String>();
        this.fields = new LinkedList<DTOField>();
        this.implementedInterfaces = new TreeSet<String>();
        this.addClassForImport(JsonProperty.class);
        this.addClassForImport(JsonIgnore.class);
        this.addClassForImport(JsonObject.class);
        this.addClassForImport(Serializable.class);
        this.addClassForImport(NotFetchedException.class);
        this.fetchOptionsClass = fetchOptionsClass;
        this.addSimpleField(fetchOptionsClass, "fetchOptions");
    }

    public String toString() {
        return this.className;
    }

    private DTOField create(String fieldName, Class<?> fieldClass, String description, Class<?> fetchOptions, String fetchOptionsFieldName) {
        return new DTOField(fieldName, fieldClass, description, fetchOptions, fetchOptionsFieldName, false);
    }

    private DTOField createPlural(String fieldName, String className, String fullClassName, String description, Class<?> fetchOptions) {
        return new DTOField(fieldName, className, fullClassName, description, fetchOptions, true);
    }

    private void setOutputStream(PrintStream printStream) {
        this.outputStream = printStream;
    }

    public DTOField addSimpleField(Class<?> c, String name) {
        DTOField field = this.create(name, c, null, null, null);
        this.fields.add(field);
        return field;
    }

    public void addBooleanField(String name) {
        this.addSimpleField(Boolean.class, name);
    }

    public void addDateField(String name) {
        this.addSimpleField(Date.class, name);
    }

    public void addStringField(String name) {
        this.addSimpleField(String.class, name);
    }

    public void addSimpleField(Class<?> c, String name, String persistentFieldName) {
        DTOField dtoField = this.create(name, c, null, null, null);
        dtoField.persistentFieldName = persistentFieldName;
        this.fields.add(dtoField);
    }

    public DTOField addFetchedField(Class<?> c, String name, String description, Class<?> fetchOptionsClass) {
        DTOField field = this.create(name, c, description, fetchOptionsClass, null);
        this.fields.add(field);
        return field;
    }

    public DTOField addFetchedField(Class<?> c, String name, String description, Class<?> fetchOptionsClass, String fetchOptionsFieldName) {
        DTOField field = this.create(name, c, description, fetchOptionsClass, fetchOptionsFieldName);
        this.fields.add(field);
        return field;
    }

    public DTOField addPluralFetchedField(String definitionClassName, String importClassName, String name, String description, Class<?> fetchOptionsClass) {
        DTOField field = this.createPlural(name, definitionClassName, importClassName, description, fetchOptionsClass);
        this.fields.add(field);
        return field;
    }

    public void addAdditionalMethod(String method) {
        this.additionalMethods.add(method);
    }

    public void addClassForImport(Class<?> c) {
        this.additionalImports.add(c.getName());
    }

    public void addImplementedInterface(Class<?> i) {
        this.implementedInterfaces.add(i.getSimpleName());
        this.additionalImports.add(i.getName());
    }

    public void addImplementedInterfaceGeneric(Class<?> i) {
        this.implementedInterfaces.add(i.getSimpleName() + "<" + this.className + ">");
        this.additionalImports.add(i.getName());
    }

    public DtoGenerator deprecated() {
        this.deprecated = true;
        return this;
    }

    public void setToStringMethod(String toStringContent) {
        this.toStringContent = toStringContent;
    }

    private void print(String code, Object ... formatArguments) {
        if (this.indent > 0 && code.length() > 0) {
            this.outputStream.print(String.format("%" + this.indent + "s", ""));
        }
        this.outputStream.println(String.format(code, formatArguments));
    }

    private void startBlock() {
        this.print("{", new Object[0]);
        this.indent += 4;
    }

    private void endBlock() {
        this.indent -= 4;
        this.print("}", new Object[0]);
    }

    public void generateDTO() throws FileNotFoundException {
        this.generateDTO("../openbis_api/source/java/ch/ethz/sis/openbis/generic/asapi/v3/dto/" + this.subPackage.replaceAll("\\.", "/") + "/" + this.className + ".java");
    }

    public void generateDTOJS() throws FileNotFoundException {
        this.generateDTOJS("../js-test/servers/common/core-plugins/tests/1/as/webapps/openbis-v3-api-test/html/dto/" + this.className + ".js");
    }

    private void generateDTO(String file) throws FileNotFoundException {
        try (PrintStream fos = new PrintStream(new FileOutputStream(file, false));){
            this.generateDTO(fos);
        }
    }

    private void generateDTOJS(String file) throws FileNotFoundException {
        try (PrintStream fos = new PrintStream(new FileOutputStream(file, false));){
            this.generateDTOJS(fos);
        }
    }

    public void generateDTO(PrintStream os) {
        this.setOutputStream(os);
        this.printHeaders();
        this.printPackage(this.subPackage);
        this.printImports();
        this.printClassHeader(this.className, this.subPackage, null, this.implementedInterfaces);
        this.startBlock();
        this.printFields();
        this.printAccessors();
        this.printAdditionalMethods();
        this.printToString();
        this.endBlock();
    }

    public void generateDTOJS(PrintStream os) {
        this.setOutputStream(os);
        this.printClassHeaderJS(this.className);
        this.startBlock();
        this.printTypeJS(this.className);
        this.printAccessorsJS();
        this.endBlock();
    }

    public void generateFetchOptions() throws FileNotFoundException {
        this.generateFetchOptions("../openbis_api/source/java/ch/ethz/sis/openbis/generic/asapi/v3/dto/" + this.subPackage.replaceAll("\\.", "/") + "/fetchoptions/" + this.className + "FetchOptions.java");
    }

    public void generateFetchOptionsJS() throws FileNotFoundException {
        this.generateFetchOptionsJS("../js-test/servers/common/core-plugins/tests/1/as/webapps/openbis-v3-api-test/html/dto/" + this.className + "FetchOptions.js");
    }

    private void generateFetchOptions(String file) throws FileNotFoundException {
        try (PrintStream fos = new PrintStream(new FileOutputStream(file, false));){
            this.generateFetchOptions(fos);
        }
    }

    private void generateFetchOptionsJS(String file) throws FileNotFoundException {
        try (PrintStream fos = new PrintStream(new FileOutputStream(file, false));){
            this.generateFetchOptionsJS(fos);
        }
    }

    public void generateFetchOptions(PrintStream os) {
        this.setOutputStream(os);
        this.printHeaders();
        this.printPackage(this.subPackage + ".fetchoptions");
        this.printImportsForFetchOptions();
        this.printClassHeader(this.fetchOptionsClass.getSimpleName(), this.subPackage + ".fetchoptions", "FetchOptions<" + this.className + ">", null);
        this.startBlock();
        this.printFetchOptionsFields();
        this.printFetchOptionsAccessors();
        this.printFetchOptionsStringBuilder();
        this.endBlock();
    }

    public void generateFetchOptionsJS(PrintStream os) {
        this.setOutputStream(os);
        this.printClassHeaderJS(this.className + "FetchOptions");
        this.startBlock();
        this.printTypeJS(this.className + "FetchOptions");
        this.printFetchOptionsAccessorsJS();
        this.endBlock();
    }

    private void printHeaders() {
        this.print("/*", new Object[0]);
        this.print(" * Copyright 2014 ETH Zuerich, CISD", new Object[0]);
        this.print(" *", new Object[0]);
        this.print(" * Licensed under the Apache License, Version 2.0 (the \"License\");", new Object[0]);
        this.print(" * you may not use this file except in compliance with the License.", new Object[0]);
        this.print(" * You may obtain a copy of the License at", new Object[0]);
        this.print(" *", new Object[0]);
        this.print(" *      http://www.apache.org/licenses/LICENSE-2.0", new Object[0]);
        this.print(" *", new Object[0]);
        this.print(" * Unless required by applicable law or agreed to in writing, software", new Object[0]);
        this.print(" * distributed under the License is distributed on an \"AS IS\" BASIS,", new Object[0]);
        this.print(" * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.", new Object[0]);
        this.print(" * See the License for the specific language governing permissions and", new Object[0]);
        this.print(" * limitations under the License.", new Object[0]);
        this.print(" */", new Object[0]);
    }

    private void printAccessors() {
        for (DTOField field : this.fields) {
            this.printAccessors(field);
        }
    }

    private void printAccessorsJS() {
        for (DTOField field : this.fields) {
            this.printAccessorsJS(field);
        }
    }

    private void printAccessors(DTOField field) {
        if (field.fetchOptions != null) {
            this.printGetterWithFetchOptions(field);
        } else {
            this.printBasicGetter(field);
        }
        this.printBasicSetter(field);
    }

    private void printAccessorsJS(DTOField field) {
        if (field.fetchOptions != null) {
            this.printGetterWithFetchOptionsJS(field);
        } else {
            this.printBasicGetterJS(field);
        }
        this.printBasicSetterJS(field);
    }

    private void printFetchOptionsAccessors() {
        for (DTOField field : this.fields) {
            if (field.fetchOptions == null || field.fetchOptionsFieldName != null) continue;
            this.printFetchOptionsAccessors(field);
        }
        this.printMethodJavaDoc();
        this.print("@Override", new Object[0]);
        this.print("public " + this.className + "SortOptions sortBy()", new Object[0]);
        this.startBlock();
        this.print("if (sort == null)", new Object[0]);
        this.startBlock();
        this.print("sort = new " + this.className + "SortOptions();", new Object[0]);
        this.endBlock();
        this.print("return sort;", new Object[0]);
        this.endBlock();
        this.print("", new Object[0]);
        this.printMethodJavaDoc();
        this.print("@Override", new Object[0]);
        this.print("public " + this.className + "SortOptions getSortBy()", new Object[0]);
        this.startBlock();
        this.print("return sort;", new Object[0]);
        this.endBlock();
    }

    private void printFetchOptionsAccessorsJS() {
        for (DTOField field : this.fields) {
            if (field.fetchOptions == null || field.fetchOptionsFieldName != null) continue;
            this.printFetchOptionsAccessorsJS(field);
        }
    }

    private void printBasicSetter(DTOField field) {
        this.printMethodJavaDoc();
        this.printSetterAnnotation(field);
        this.print("public void set%s(%s %s)", field.getCapitalizedName(), field.definitionClassName, field.getPersistentName());
        this.startBlock();
        this.print("this.%s = %s;", field.getPersistentName(), field.getPersistentName());
        this.endBlock();
        this.print("", new Object[0]);
    }

    private void printBasicSetterJS(DTOField field) {
        this.print("this.set%s = function(%s)", field.getCapitalizedName(), field.getPersistentName());
        this.startBlock();
        this.print("this.%s = %s;", field.getPersistentName(), field.getPersistentName());
        this.endBlock();
        this.print("", new Object[0]);
    }

    private void printSetterAnnotation(DTOField field) {
        Method interfaceMethod = null;
        if (field.interfaceClass != null) {
            interfaceMethod = BeanUtils.findMethodWithMinimalParameters(field.interfaceClass, (String)("set" + field.getCapitalizedName()));
        }
        if (interfaceMethod != null) {
            this.print("@Override", new Object[0]);
        }
        this.printDeprecated(field.deprecated);
    }

    private void printGetterAnnotation(DTOField field) {
        this.print("@JsonIgnore", new Object[0]);
        Method interfaceMethod = null;
        if (field.interfaceClass != null) {
            interfaceMethod = BeanUtils.findMethodWithMinimalParameters(field.interfaceClass, (String)("get" + field.getCapitalizedName()));
        }
        if (interfaceMethod != null) {
            this.print("@Override", new Object[0]);
        }
        this.printDeprecated(field.deprecated);
    }

    private void printGetterWithFetchOptions(DTOField field) {
        this.printMethodJavaDoc();
        this.printGetterAnnotation(field);
        if (field.definitionClassName.equals("Boolean")) {
            this.print("public %s is%s()", field.definitionClassName, field.getCapitalizedName());
        } else {
            this.print("public %s get%s()", field.definitionClassName, field.getCapitalizedName());
        }
        this.startBlock();
        this.print("if (getFetchOptions() != null && getFetchOptions().has%s())", field.getFetchOptionsFieldName());
        this.startBlock();
        this.print("return %s;", field.getPersistentName());
        this.endBlock();
        this.print("else", new Object[0]);
        this.startBlock();
        if (field.plural) {
            this.print("throw new NotFetchedException(\"%s have not been fetched.\");", field.description);
        } else {
            this.print("throw new NotFetchedException(\"%s has not been fetched.\");", field.description);
        }
        this.endBlock();
        this.endBlock();
        this.print("", new Object[0]);
    }

    private void printGetterWithFetchOptionsJS(DTOField field) {
        this.print("this.get%s = function()", field.getCapitalizedName());
        this.startBlock();
        this.print("if (getFetchOptions() != null && this.getFetchOptions().has%s())", field.getFetchOptionsFieldName());
        this.startBlock();
        this.print("return %s;", field.getPersistentName());
        this.endBlock();
        this.print("else", new Object[0]);
        this.startBlock();
        if (field.plural) {
            this.print("throw '%s have not been fetched.'", field.description);
        } else {
            this.print("throw '%s has not been fetched.'", field.description);
        }
        this.endBlock();
        this.endBlock();
        this.print("", new Object[0]);
    }

    private void printBasicGetter(DTOField field) {
        this.printMethodJavaDoc();
        this.printGetterAnnotation(field);
        if (field.definitionClassName.equals("Boolean")) {
            this.print("public %s is%s()", field.definitionClassName, field.getCapitalizedName());
        } else {
            this.print("public %s get%s()", field.definitionClassName, field.getCapitalizedName());
        }
        this.startBlock();
        this.print("return %s;", field.getPersistentName());
        this.endBlock();
        this.print("", new Object[0]);
    }

    private void printBasicGetterJS(DTOField field) {
        if (field.definitionClassName.equals("Boolean")) {
            this.print("this.is%s = function()", field.getCapitalizedName());
        } else {
            this.print("this.get%s = function()", field.getCapitalizedName());
        }
        this.startBlock();
        this.print("return %s;", field.getPersistentName());
        this.endBlock();
        this.print("", new Object[0]);
    }

    private void printFetchOptionsAccessors(DTOField field) {
        this.printMethodJavaDoc();
        this.printDeprecated(field.deprecated);
        this.print("public %s with%s()", field.fetchOptions.getSimpleName(), field.getCapitalizedName());
        this.startBlock();
        this.print("if (%s == null)", field.getPersistentName());
        this.startBlock();
        this.print("%s = new %s();", field.getPersistentName(), field.fetchOptions.getSimpleName());
        this.endBlock();
        this.print("return %s;", field.getPersistentName());
        this.endBlock();
        this.print("", new Object[0]);
        this.printMethodJavaDoc();
        this.printDeprecated(field.deprecated);
        this.print("public %s with%sUsing(%s fetchOptions)", field.fetchOptions.getSimpleName(), field.getCapitalizedName(), field.fetchOptions.getSimpleName());
        this.startBlock();
        this.print("return %s = fetchOptions;", field.getPersistentName());
        this.endBlock();
        this.print("", new Object[0]);
        this.printMethodJavaDoc();
        this.printDeprecated(field.deprecated);
        this.print("public boolean has%s()", field.getCapitalizedName());
        this.startBlock();
        this.print("return %s != null;", field.getPersistentName());
        this.endBlock();
        this.print("", new Object[0]);
    }

    private void printFetchOptionsAccessorsJS(DTOField field) {
        this.print("this.fetch%s = function()", field.getCapitalizedName());
        this.startBlock();
        this.print("if (!this.%s)", field.getPersistentName());
        this.startBlock();
        this.print("this.%s = new %s();", field.getPersistentName(), field.fetchOptions.getSimpleName());
        this.endBlock();
        this.print("return this.%s;", field.getPersistentName());
        this.endBlock();
        this.print("", new Object[0]);
        this.print("this.has%s = function()", field.getCapitalizedName());
        this.startBlock();
        this.print("return this.%s;", field.getPersistentName());
        this.endBlock();
        this.print("", new Object[0]);
    }

    private void printClassHeader(String className, String jsonPackage, String extendsClass, Collection<String> implementedInterfaces) {
        this.print("/*", new Object[0]);
        this.print(" * Class automatically generated with %s", this.getClass().getSimpleName());
        this.print(" */", new Object[0]);
        this.print("@JsonObject(\"as.dto.%s.%s\")", jsonPackage, className);
        this.printDeprecated(this.deprecated);
        String extendsStr = "";
        if (extendsClass != null) {
            extendsStr = " extends " + extendsClass;
        }
        StringBuilder interfaces = new StringBuilder();
        if (implementedInterfaces != null) {
            for (String i : implementedInterfaces) {
                interfaces.append(", ");
                interfaces.append(i);
            }
        }
        this.print("public class %s%s implements Serializable%s", className, extendsStr, interfaces.toString());
    }

    private void printMethodJavaDoc() {
        this.print("// Method automatically generated with %s", this.getClass().getSimpleName());
    }

    private void printClassHeaderJS(String className) {
        this.print("var %s = function()", className);
    }

    private void printTypeJS(String className) {
        this.print("this['@type'] = '%s';", className);
    }

    private void printFields() {
        this.print("private static final long serialVersionUID = 1L;", new Object[0]);
        this.print("", new Object[0]);
        for (DTOField field : this.fields) {
            this.printField(field);
        }
    }

    private void printField(DTOField field) {
        this.printJsonPropertyAnnotation(field);
        this.printDeprecated(field.deprecated);
        this.print("private %s %s;", field.definitionClassName, field.getPersistentName());
        this.print("", new Object[0]);
    }

    private void printFetchOptionsFields() {
        this.print("private static final long serialVersionUID = 1L;", new Object[0]);
        this.print("", new Object[0]);
        for (DTOField field : this.fields) {
            if (field.fetchOptions == null || field.fetchOptionsFieldName != null) continue;
            this.printFetchOptionField(field);
        }
        this.print("@JsonProperty", new Object[0]);
        this.print("private " + this.className + "SortOptions sort;", new Object[0]);
        this.print("", new Object[0]);
    }

    private void printFetchOptionField(DTOField field) {
        this.printJsonPropertyAnnotation(field);
        this.printDeprecated(field.deprecated);
        this.print("private %s %s;", field.fetchOptions.getSimpleName(), field.getPersistentName());
        this.print("", new Object[0]);
    }

    private void printFetchOptionsStringBuilder() {
        this.print("@Override", new Object[0]);
        this.print("protected FetchOptionsToStringBuilder getFetchOptionsStringBuilder()", new Object[0]);
        this.startBlock();
        this.print("FetchOptionsToStringBuilder f = new FetchOptionsToStringBuilder(\"" + this.className + "\", this);", new Object[0]);
        for (DTOField field : this.fields) {
            if (field.fetchOptions == null || field.fetchOptionsFieldName != null) continue;
            this.print("f.addFetchOption(\"" + field.getCapitalizedName() + "\", " + field.fieldName + ");", new Object[0]);
        }
        this.print("return f;", new Object[0]);
        this.endBlock();
        this.print("", new Object[0]);
    }

    protected void printJsonPropertyAnnotation(DTOField field) {
        if (field.fieldName.equalsIgnoreCase(field.getPersistentName())) {
            this.print("@JsonProperty", new Object[0]);
        } else {
            this.print("@JsonProperty(value=\"%s\")", field.fieldName);
        }
    }

    private void printImports() {
        TreeSet<String> imports = new TreeSet<String>();
        for (DTOField field : this.fields) {
            if (field.importClassName == null) continue;
            imports.add(field.importClassName);
        }
        imports.addAll(this.additionalImports);
        for (String s : imports) {
            if (s.startsWith("java.lang")) continue;
            this.print("import %s;", s);
        }
        this.print("", new Object[0]);
    }

    private void printImportsForFetchOptions() {
        TreeSet<String> imports = new TreeSet<String>();
        imports.add(JsonObject.class.getName());
        imports.add(JsonProperty.class.getName());
        imports.add(Serializable.class.getName());
        imports.add(FetchOptions.class.getName());
        imports.add("ch.ethz.sis.openbis.generic.asapi.v3.dto." + this.subPackage + "." + this.className);
        imports.add("ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptionsToStringBuilder");
        for (DTOField field : this.fields) {
            if (field.fetchOptions == null || field.fetchOptionsFieldName != null) continue;
            imports.add(field.fetchOptions.getName());
        }
        for (String s : imports) {
            this.print("import %s;", s);
        }
        this.print("", new Object[0]);
    }

    private void printDeprecated(boolean deprecated) {
        if (deprecated) {
            this.print("@Deprecated", new Object[0]);
        }
    }

    private void printPackage(String p) {
        this.print("package %s.%s;", PACKAGE_PREFIX, p);
        this.print("", new Object[0]);
    }

    private void printToString() {
        if (this.toStringContent != null) {
            this.printMethodJavaDoc();
            this.print("@Override", new Object[0]);
            this.print("public String toString()", new Object[0]);
            this.startBlock();
            this.print("return %s;", this.toStringContent);
            this.endBlock();
            this.print("", new Object[0]);
        }
    }

    private void printAdditionalMethods() {
        for (String additionalMethod : this.additionalMethods) {
            this.print(additionalMethod, new Object[0]);
            this.print("", new Object[0]);
        }
    }

    class DTOField {
        String fieldName;
        String persistentFieldName;
        String description;
        String definitionClassName;
        String importClassName;
        Class<?> fetchOptions;
        String fetchOptionsFieldName;
        boolean plural;
        Class<?> interfaceClass;
        boolean deprecated;

        private DTOField(String fieldName, Class<?> fieldClass, String description, Class<?> fetchOptions, String fetchOptionsFieldName, boolean plural) {
            this.fieldName = fieldName;
            this.definitionClassName = fieldClass.getSimpleName();
            if (!(fieldClass.isArray() || fieldClass.isPrimitive())) {
                this.importClassName = fieldClass.getCanonicalName();
            }
            this.description = description;
            this.fetchOptions = fetchOptions;
            this.fetchOptionsFieldName = fetchOptionsFieldName;
            this.plural = plural;
        }

        private DTOField(String fieldName, String className, String fullClassName, String description, Class<?> fetchOptions, boolean plural) {
            this.fieldName = fieldName;
            this.definitionClassName = className;
            this.importClassName = fullClassName;
            this.description = description;
            this.fetchOptions = fetchOptions;
            this.plural = plural;
        }

        String getPersistentName() {
            return this.persistentFieldName == null ? this.fieldName : this.persistentFieldName;
        }

        String getCapitalizedName() {
            return this.fieldName.substring(0, 1).toUpperCase() + this.fieldName.substring(1);
        }

        String getFetchOptionsFieldName() {
            if (this.fetchOptionsFieldName == null) {
                return this.getCapitalizedName();
            }
            return this.fetchOptionsFieldName.substring(0, 1).toUpperCase() + this.fetchOptionsFieldName.substring(1);
        }

        void withInterface(Class<?> i) {
            DtoGenerator.this.addImplementedInterface(i);
            this.interfaceClass = i;
        }

        void withInterfaceReflexive(Class<?> i) {
            DtoGenerator.this.addImplementedInterfaceGeneric(i);
            this.interfaceClass = i;
        }

        DTOField deprecated() {
            this.deprecated = true;
            return this;
        }
    }
}

