/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.generators;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.Attachment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.fetchoptions.AttachmentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.EmptyFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IDataSetsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IEntityType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IEntityTypeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IExperimentsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IIdentifierHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IMaterialsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IOwnerHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IParentChildrenHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IProjectHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IProjectsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPropertyTypeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ISamplesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationExecutionError;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationExecutionProgress;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.ArchivingStatus;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.Complete;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.FileFormatType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.LinkedData;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.LocatorType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.PhysicalData;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.StorageFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.FileFormatTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.LinkedDataFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.LocatorTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.PhysicalDataFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.StorageFormatFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.DataStore;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.fetchoptions.DataStoreFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.fetchoptions.DeletedObjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.fetchoptions.DeletionFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.id.IDeletionId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.fetchoptions.EntityTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.event.EntityType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.event.EventType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.event.fetchoptions.EventFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.event.id.IEventId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.ExperimentType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.ExternalDms;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.fetchoptions.ExternalDmsFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.fetchoptions.GlobalSearchObjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchObjectKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.HistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.fetchoptions.HistoryEntryFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.MaterialType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.fetchoptions.MaterialFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.fetchoptions.MaterialTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.id.MaterialPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.objectkindmodification.ObjectKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.objectkindmodification.OperationKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.objectkindmodification.fetchoptions.ObjectKindModificationFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.IOperationExecutionNotification;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionAvailability;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionDetails;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionState;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionSummary;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.fetchoptions.OperationExecutionDetailsFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.fetchoptions.OperationExecutionFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.fetchoptions.OperationExecutionNotificationFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.fetchoptions.OperationExecutionSummaryFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.id.OperationExecutionPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.fetchoptions.PersonFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.PersonPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.fetchoptions.ProjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.IProjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.DataType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyAssignment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.fetchoptions.PropertyAssignmentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.fetchoptions.PropertyTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyAssignmentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.QueryType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.fetchoptions.QueryDatabaseFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.fetchoptions.QueryFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.QueryDatabaseName;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.Role;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.RoleLevel;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.SampleType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.fetchoptions.SemanticAnnotationFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.id.SemanticAnnotationPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.fetchoptions.CustomASServiceFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.CustomASServiceCode;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.fetchoptions.SpaceFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.ISpaceId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.fetchoptions.TagFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.TagPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.Vocabulary;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.fetchoptions.VocabularyFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.fetchoptions.VocabularyTermFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.VocabularyTermPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.generators.AbstractGenerator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.generators.DtoGenerator;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class Generator
extends AbstractGenerator {
    private static DtoGenerator createSampleGenerator() {
        DtoGenerator gen = new DtoGenerator("sample", "Sample", SampleFetchOptions.class);
        Generator.addPermId(gen, SamplePermId.class);
        gen.addSimpleField(SampleIdentifier.class, "identifier").withInterface(IIdentifierHolder.class);
        Generator.addCode(gen);
        Generator.addRegistrationDate(gen);
        Generator.addModificationDate(gen);
        gen.addFetchedField(SampleType.class, "type", "Sample type", SampleTypeFetchOptions.class).withInterface(IEntityTypeHolder.class);
        gen.addFetchedField(Project.class, "project", "Project", ProjectFetchOptions.class);
        Generator.addSpace(gen);
        Generator.addExperiment(gen);
        Generator.addProperties(gen);
        gen.addPluralFetchedField("List<Sample>", List.class.getName(), "parents", "Parents", SampleFetchOptions.class).withInterfaceReflexive(IParentChildrenHolder.class);
        gen.addPluralFetchedField("List<Sample>", List.class.getName(), "children", "Children", SampleFetchOptions.class).withInterfaceReflexive(IParentChildrenHolder.class);
        gen.addFetchedField(Sample.class, "container", "Container sample", SampleFetchOptions.class);
        gen.addPluralFetchedField("List<Sample>", List.class.getName(), "components", "Component samples", SampleFetchOptions.class);
        gen.addPluralFetchedField("List<DataSet>", List.class.getName(), "dataSets", "Data sets", DataSetFetchOptions.class).withInterface(IDataSetsHolder.class);
        gen.addClassForImport(DataSet.class);
        gen.addPluralFetchedField("List<HistoryEntry>", List.class.getName(), "history", "History", HistoryEntryFetchOptions.class);
        gen.addClassForImport(HistoryEntry.class);
        Generator.addTags(gen);
        Generator.addRegistrator(gen);
        Generator.addModifier(gen);
        Generator.addAttachments(gen);
        gen.setToStringMethod("\"Sample \" + permId");
        return gen;
    }

    private static DtoGenerator createSampleTypeGenerator() {
        DtoGenerator gen = new DtoGenerator("sample", "SampleType", SampleTypeFetchOptions.class);
        gen.addImplementedInterface(IEntityType.class);
        Generator.addPermId(gen, EntityTypePermId.class);
        Generator.addCode(gen);
        Generator.addDescription(gen);
        gen.addBooleanField("listable");
        gen.addBooleanField("subcodeUnique");
        gen.addBooleanField("autoGeneratedCode");
        gen.addBooleanField("showContainer");
        gen.addBooleanField("showParents");
        gen.addBooleanField("showParentMetadata");
        gen.addStringField("generatedCodePrefix");
        Generator.addModificationDate(gen);
        gen.setToStringMethod("\"SampleType \" + code");
        Generator.addPropertyAssignments(gen);
        Generator.addSemanticAnnotations(gen);
        return gen;
    }

    private static DtoGenerator createAttachmentGenerator() {
        DtoGenerator gen = new DtoGenerator("attachment", "Attachment", AttachmentFetchOptions.class);
        gen.addStringField("fileName");
        gen.addStringField("title");
        Generator.addDescription(gen);
        gen.addStringField("permlink");
        gen.addStringField("latestVersionPermlink");
        gen.addSimpleField(Integer.class, "version");
        Generator.addRegistrationDate(gen);
        Generator.addRegistrator(gen);
        gen.addFetchedField(Attachment.class, "previousVersion", "Previous version of attachment ", AttachmentFetchOptions.class);
        gen.addFetchedField(byte[].class, "content", "Content", EmptyFetchOptions.class);
        gen.setToStringMethod("\"Attachment \" + fileName + \":\" + version");
        return gen;
    }

    private static DtoGenerator createExperimentGenerator() {
        DtoGenerator gen = new DtoGenerator("experiment", "Experiment", ExperimentFetchOptions.class);
        Generator.addPermId(gen, ExperimentPermId.class);
        gen.addSimpleField(ExperimentIdentifier.class, "identifier").withInterface(IIdentifierHolder.class);
        Generator.addCode(gen);
        Generator.addRegistrationDate(gen);
        Generator.addModificationDate(gen);
        gen.addFetchedField(ExperimentType.class, "type", "Experiment type", ExperimentTypeFetchOptions.class).withInterface(IEntityTypeHolder.class);
        gen.addFetchedField(Project.class, "project", "Project", ProjectFetchOptions.class).withInterface(IProjectHolder.class);
        gen.addPluralFetchedField("List<DataSet>", List.class.getName(), "dataSets", "Data sets", DataSetFetchOptions.class).withInterface(IDataSetsHolder.class);
        gen.addClassForImport(DataSet.class);
        gen.addPluralFetchedField("List<Sample>", List.class.getName(), "samples", "Samples", SampleFetchOptions.class).withInterface(ISamplesHolder.class);
        gen.addClassForImport(Sample.class);
        gen.addPluralFetchedField("List<HistoryEntry>", List.class.getName(), "history", "History", HistoryEntryFetchOptions.class);
        gen.addClassForImport(HistoryEntry.class);
        Generator.addProperties(gen);
        Generator.addTags(gen);
        Generator.addRegistrator(gen);
        Generator.addModifier(gen);
        Generator.addAttachments(gen);
        gen.setToStringMethod("\"Experiment \" + permId");
        return gen;
    }

    private static DtoGenerator createExperimentTypeGenerator() {
        DtoGenerator gen = new DtoGenerator("experiment", "ExperimentType", ExperimentTypeFetchOptions.class);
        gen.addImplementedInterface(IEntityType.class);
        Generator.addPermId(gen, EntityTypePermId.class);
        Generator.addCode(gen);
        Generator.addDescription(gen);
        Generator.addModificationDate(gen);
        gen.setToStringMethod("\"ExperimentType \" + code");
        Generator.addPropertyAssignments(gen);
        return gen;
    }

    private static DtoGenerator createDataSetGenerator() {
        DtoGenerator gen = new DtoGenerator("dataset", "DataSet", DataSetFetchOptions.class);
        Generator.addPermId(gen, DataSetPermId.class);
        Generator.addCode(gen);
        gen.addFetchedField(DataSetType.class, "type", "Data Set type", DataSetTypeFetchOptions.class).withInterface(IEntityTypeHolder.class);
        gen.addFetchedField(DataStore.class, "dataStore", "Data store", DataStoreFetchOptions.class);
        gen.addBooleanField("measured");
        gen.addBooleanField("postRegistered");
        gen.addFetchedField(PhysicalData.class, "physicalData", "Physical data", PhysicalDataFetchOptions.class);
        gen.addFetchedField(LinkedData.class, "linkedData", "Linked data", LinkedDataFetchOptions.class);
        Generator.addExperiment(gen);
        Generator.addSample(gen);
        Generator.addProperties(gen);
        gen.addPluralFetchedField("List<DataSet>", List.class.getName(), "parents", "Parents", DataSetFetchOptions.class).withInterfaceReflexive(IParentChildrenHolder.class);
        gen.addPluralFetchedField("List<DataSet>", List.class.getName(), "children", "Children", DataSetFetchOptions.class).withInterfaceReflexive(IParentChildrenHolder.class);
        gen.addPluralFetchedField("List<DataSet>", List.class.getName(), "containers", "Container data sets", DataSetFetchOptions.class);
        gen.addPluralFetchedField("List<DataSet>", List.class.getName(), "components", "Component data sets", DataSetFetchOptions.class);
        Generator.addTags(gen);
        gen.addPluralFetchedField("List<HistoryEntry>", List.class.getName(), "history", "History", HistoryEntryFetchOptions.class);
        gen.addClassForImport(HistoryEntry.class);
        Generator.addModificationDate(gen);
        Generator.addModifier(gen);
        Generator.addRegistrationDate(gen);
        Generator.addRegistrator(gen);
        gen.addSimpleField(String.class, "dataProducer");
        gen.addDateField("dataProductionDate");
        gen.addDateField("accessDate");
        gen.setToStringMethod("\"DataSet \" + code");
        return gen;
    }

    private static DtoGenerator createDataSetTypeGenerator() {
        DtoGenerator gen = new DtoGenerator("dataset", "DataSetType", DataSetTypeFetchOptions.class);
        gen.addImplementedInterface(IEntityType.class);
        Generator.addPermId(gen, EntityTypePermId.class);
        Generator.addCode(gen);
        Generator.addDescription(gen);
        gen.addStringField("mainDataSetPattern");
        gen.addStringField("mainDataSetPath");
        gen.addBooleanField("disallowDeletion");
        Generator.addModificationDate(gen);
        gen.setToStringMethod("\"DataSetType \" + code");
        Generator.addPropertyAssignments(gen);
        return gen;
    }

    private static DtoGenerator createPhysicalDataGenerator() {
        DtoGenerator gen = new DtoGenerator("dataset", "PhysicalData", PhysicalDataFetchOptions.class);
        gen.addStringField("shareId");
        gen.addStringField("location");
        gen.addSimpleField(Long.class, "size");
        gen.addFetchedField(StorageFormat.class, "storageFormat", "Storage format", StorageFormatFetchOptions.class);
        gen.addFetchedField(FileFormatType.class, "fileFormatType", "File Format Type", FileFormatTypeFetchOptions.class).deprecated();
        gen.addFetchedField(LocatorType.class, "locatorType", "Locator Type", LocatorTypeFetchOptions.class);
        gen.addSimpleField(Complete.class, "complete");
        gen.addSimpleField(ArchivingStatus.class, "status");
        gen.addBooleanField("presentInArchive");
        gen.addBooleanField("storageConfirmation");
        gen.addSimpleField(Integer.class, "speedHint");
        gen.addBooleanField("archivingRequested");
        gen.setToStringMethod("\"PhysicalData \" + location");
        return gen;
    }

    private static DtoGenerator createLinkedDataGenerator() {
        DtoGenerator gen = new DtoGenerator("dataset", "LinkedData", LinkedDataFetchOptions.class);
        gen.addStringField("externalCode");
        gen.addFetchedField(ExternalDms.class, "externalDms", "External data management system", ExternalDmsFetchOptions.class);
        gen.setToStringMethod("\"LinkedData \" + externalCode");
        return gen;
    }

    private static DtoGenerator createFileFormatType() {
        DtoGenerator gen = new DtoGenerator("dataset", "FileFormatType", FileFormatTypeFetchOptions.class).deprecated();
        Generator.addCode(gen);
        gen.addStringField("description");
        gen.setToStringMethod("\"FileFormatType \" + code");
        return gen;
    }

    private static DtoGenerator createStorageFormat() {
        DtoGenerator gen = new DtoGenerator("dataset", "StorageFormat", StorageFormatFetchOptions.class);
        Generator.addCode(gen);
        gen.addStringField("description");
        gen.setToStringMethod("\"StorageFormat \" + code");
        return gen;
    }

    private static DtoGenerator createLocatorType() {
        DtoGenerator gen = new DtoGenerator("dataset", "LocatorType", LocatorTypeFetchOptions.class);
        Generator.addCode(gen);
        gen.addStringField("description");
        gen.setToStringMethod("\"LocatorType \" + code");
        return gen;
    }

    private static DtoGenerator createDeletion() {
        DtoGenerator gen = new DtoGenerator("deletion", "Deletion", DeletionFetchOptions.class);
        gen.addSimpleField(IDeletionId.class, "id");
        gen.addStringField("reason");
        gen.addPluralFetchedField("List<DeletedObject>", List.class.getName(), "deletedObjects", "Deleted objects", DeletedObjectFetchOptions.class);
        gen.addSimpleField(Date.class, "deletionDate");
        gen.setToStringMethod("\"Deletion \" + id");
        return gen;
    }

    private static DtoGenerator createEvent() {
        DtoGenerator gen = new DtoGenerator("event", "Event", EventFetchOptions.class);
        gen.addSimpleField(IEventId.class, "id");
        gen.addSimpleField(EventType.class, "eventType");
        gen.addSimpleField(EntityType.class, "entityType");
        gen.addStringField("entitySpace");
        gen.addSimpleField(ISpaceId.class, "entitySpaceId");
        gen.addStringField("entityProject");
        gen.addSimpleField(IProjectId.class, "entityProjectId");
        gen.addStringField("entityRegistrator");
        gen.addSimpleField(Date.class, "entityRegistrationDate");
        gen.addStringField("identifier");
        gen.addStringField("description");
        gen.addStringField("reason");
        gen.addStringField("content");
        Generator.addRegistrator(gen);
        Generator.addRegistrationDate(gen);
        gen.setToStringMethod("\"Event \" + id");
        return gen;
    }

    private static DtoGenerator createVocabulary() {
        DtoGenerator gen = new DtoGenerator("vocabulary", "Vocabulary", VocabularyFetchOptions.class);
        Generator.addCode(gen);
        Generator.addDescription(gen);
        Generator.addRegistrationDate(gen);
        Generator.addRegistrator(gen);
        Generator.addModificationDate(gen);
        gen.setToStringMethod("\"Vocabulary \" + code");
        return gen;
    }

    private static DtoGenerator createVocabularyTerm() {
        DtoGenerator gen = new DtoGenerator("vocabulary", "VocabularyTerm", VocabularyTermFetchOptions.class);
        Generator.addPermId(gen, VocabularyTermPermId.class);
        Generator.addCode(gen);
        gen.addStringField("label");
        Generator.addDescription(gen);
        gen.addSimpleField(Long.class, "ordinal");
        gen.addBooleanField("official");
        gen.addFetchedField(Vocabulary.class, "vocabulary", "Vocabulary", VocabularyFetchOptions.class);
        Generator.addRegistrationDate(gen);
        Generator.addRegistrator(gen);
        Generator.addModificationDate(gen);
        gen.setToStringMethod("\"VocabularyTerm \" + code");
        return gen;
    }

    private static DtoGenerator createPersonGenerator() {
        DtoGenerator gen = new DtoGenerator("person", "Person", PersonFetchOptions.class);
        Generator.addPermId(gen, PersonPermId.class);
        gen.addStringField("userId");
        gen.addStringField("firstName");
        gen.addStringField("lastName");
        gen.addStringField("email");
        Generator.addRegistrationDate(gen);
        gen.addBooleanField("active");
        Generator.addSpace(gen);
        Generator.addRegistrator(gen);
        gen.setToStringMethod("\"Person \" + userId");
        return gen;
    }

    private static DtoGenerator createProjectGenerator() {
        DtoGenerator gen = new DtoGenerator("project", "Project", ProjectFetchOptions.class);
        Generator.addPermId(gen, ProjectPermId.class);
        gen.addSimpleField(ProjectIdentifier.class, "identifier").withInterface(IIdentifierHolder.class);
        Generator.addCode(gen);
        Generator.addDescription(gen);
        Generator.addRegistrationDate(gen);
        Generator.addModificationDate(gen);
        gen.addPluralFetchedField("List<Experiment>", List.class.getName(), "experiments", "Experiments", ExperimentFetchOptions.class).withInterface(IExperimentsHolder.class);
        gen.addClassForImport(Experiment.class);
        gen.addPluralFetchedField("List<Sample>", List.class.getName(), "samples", "Samples", SampleFetchOptions.class);
        gen.addClassForImport(Sample.class);
        gen.addPluralFetchedField("List<HistoryEntry>", List.class.getName(), "history", "History", HistoryEntryFetchOptions.class);
        gen.addClassForImport(HistoryEntry.class);
        Generator.addSpace(gen);
        Generator.addRegistrator(gen);
        Generator.addModifier(gen);
        gen.addFetchedField(Person.class, "leader", "Leader", PersonFetchOptions.class);
        Generator.addAttachments(gen);
        gen.setToStringMethod("\"Project \" + permId");
        return gen;
    }

    private static DtoGenerator createSpaceGenerator() {
        DtoGenerator gen = new DtoGenerator("space", "Space", SpaceFetchOptions.class);
        Generator.addPermId(gen, SpacePermId.class);
        Generator.addCode(gen);
        Generator.addDescription(gen);
        Generator.addRegistrationDate(gen);
        Generator.addModificationDate(gen);
        Generator.addRegistrator(gen);
        gen.addPluralFetchedField("List<Sample>", List.class.getName(), "samples", "Samples", SampleFetchOptions.class).withInterface(ISamplesHolder.class);
        gen.addClassForImport(Sample.class);
        gen.addPluralFetchedField("List<Project>", List.class.getName(), "projects", "Projects", ProjectFetchOptions.class).withInterface(IProjectsHolder.class);
        gen.addClassForImport(Project.class);
        gen.setToStringMethod("\"Space \" + permId");
        return gen;
    }

    private static DtoGenerator createTagGenerator() {
        DtoGenerator gen = new DtoGenerator("tag", "Tag", TagFetchOptions.class);
        Generator.addPermId(gen, TagPermId.class);
        Generator.addCode(gen);
        Generator.addDescription(gen);
        gen.addSimpleField(Boolean.class, "private", "isPrivate");
        gen.addPluralFetchedField("List<Experiment>", List.class.getName(), "experiments", "Experiments", ExperimentFetchOptions.class).withInterface(IExperimentsHolder.class);
        gen.addClassForImport(Experiment.class);
        gen.addPluralFetchedField("List<Sample>", List.class.getName(), "samples", "Samples", SampleFetchOptions.class).withInterface(ISamplesHolder.class);
        gen.addClassForImport(Sample.class);
        gen.addPluralFetchedField("List<DataSet>", List.class.getName(), "dataSets", "Data sets", DataSetFetchOptions.class).withInterface(IDataSetsHolder.class);
        gen.addClassForImport(DataSet.class);
        gen.addPluralFetchedField("List<Material>", List.class.getName(), "materials", "Materials", MaterialFetchOptions.class).withInterface(IMaterialsHolder.class);
        gen.addClassForImport(Material.class);
        Generator.addRegistrationDate(gen);
        gen.addFetchedField(Person.class, "owner", "Owner", PersonFetchOptions.class).withInterface(IOwnerHolder.class);
        gen.setToStringMethod("\"Tag \" + code");
        return gen;
    }

    private static DtoGenerator createMaterialGenerator() {
        DtoGenerator gen = new DtoGenerator("material", "Material", MaterialFetchOptions.class);
        Generator.addPermId(gen, MaterialPermId.class);
        Generator.addCode(gen);
        gen.addFetchedField(MaterialType.class, "type", "Material type", MaterialTypeFetchOptions.class).withInterface(IEntityTypeHolder.class);
        gen.addPluralFetchedField("List<HistoryEntry>", List.class.getName(), "history", "History", HistoryEntryFetchOptions.class);
        gen.addClassForImport(HistoryEntry.class);
        Generator.addRegistrationDate(gen);
        Generator.addRegistrator(gen);
        Generator.addModificationDate(gen);
        Generator.addProperties(gen);
        Generator.addTags(gen);
        gen.setToStringMethod("\"Material \" + code");
        return gen;
    }

    private static DtoGenerator createMaterialTypeGenerator() {
        DtoGenerator gen = new DtoGenerator("material", "MaterialType", MaterialTypeFetchOptions.class);
        gen.addImplementedInterface(IEntityType.class);
        Generator.addPermId(gen, EntityTypePermId.class);
        Generator.addCode(gen);
        Generator.addDescription(gen);
        Generator.addModificationDate(gen);
        gen.setToStringMethod("\"MaterialType \" + code");
        Generator.addPropertyAssignments(gen);
        return gen;
    }

    private static DtoGenerator createHistoryEntryGenerator() {
        DtoGenerator gen = new DtoGenerator("history", "HistoryEntry", HistoryEntryFetchOptions.class);
        gen.addSimpleField(Date.class, "validFrom");
        gen.addSimpleField(Date.class, "validTo");
        gen.addFetchedField(Person.class, "author", "Author", PersonFetchOptions.class);
        gen.setToStringMethod("\"HistoryEntry from: \" + validFrom + \", to: \" + validTo");
        return gen;
    }

    private static DtoGenerator createDataStoreGenerator() {
        DtoGenerator gen = new DtoGenerator("datastore", "DataStore", DataStoreFetchOptions.class);
        Generator.addCode(gen);
        gen.addStringField("downloadUrl");
        gen.addStringField("remoteUrl");
        Generator.addRegistrationDate(gen);
        Generator.addModificationDate(gen);
        gen.setToStringMethod("\"DataStore code: \" + code");
        return gen;
    }

    private static DtoGenerator createExternalDmsGenerator() {
        DtoGenerator gen = new DtoGenerator("externaldms", "ExternalDms", ExternalDmsFetchOptions.class);
        Generator.addCode(gen);
        gen.addStringField("label");
        gen.addStringField("urlTemplate");
        gen.addBooleanField("openbis");
        gen.setToStringMethod("\"ExternalDms code: \" + code");
        return gen;
    }

    private static DtoGenerator createCustomASServiceGenerator() {
        DtoGenerator gen = new DtoGenerator("service", "CustomASService", CustomASServiceFetchOptions.class);
        gen.addSimpleField(CustomASServiceCode.class, "code");
        gen.addStringField("label");
        gen.addStringField("description");
        gen.setToStringMethod("\"CustomASService code: \" + code");
        return gen;
    }

    private static DtoGenerator createObjectKindModificationGenerator() {
        DtoGenerator gen = new DtoGenerator("objectkindmodification", "ObjectKindModification", ObjectKindModificationFetchOptions.class);
        gen.addSimpleField(ObjectKind.class, "objectKind");
        gen.addSimpleField(OperationKind.class, "operationKind");
        gen.addDateField("lastModificationTimeStamp");
        gen.setToStringMethod("\"Last \" + operationKind + \" operation of an object of kind \" + objectKind + \" occured at \" +  lastModificationTimeStamp");
        return gen;
    }

    private static DtoGenerator createGlobalSearchObject() {
        DtoGenerator gen = new DtoGenerator("global", "GlobalSearchObject", GlobalSearchObjectFetchOptions.class);
        gen.addSimpleField(GlobalSearchObjectKind.class, "objectKind");
        gen.addSimpleField(IObjectId.class, "objectPermId");
        gen.addSimpleField(IObjectId.class, "objectIdentifier");
        gen.addStringField("match");
        gen.addSimpleField(Double.TYPE, "score");
        gen.addFetchedField(Experiment.class, "experiment", "Experiment", ExperimentFetchOptions.class);
        gen.addFetchedField(Sample.class, "sample", "Sample", SampleFetchOptions.class);
        gen.addFetchedField(DataSet.class, "dataSet", "Data Set", DataSetFetchOptions.class);
        gen.addFetchedField(Material.class, "material", "Material", MaterialFetchOptions.class);
        gen.setToStringMethod("\"GlobalSearchObject kind: \" + objectKind + \", permId: \" + objectPermId + \", identifier: \" + objectIdentifier");
        return gen;
    }

    private static DtoGenerator createPropertyAssignmentGenerator() {
        DtoGenerator gen = new DtoGenerator("property", "PropertyAssignment", PropertyAssignmentFetchOptions.class);
        Generator.addPermId(gen, PropertyAssignmentPermId.class);
        gen.addStringField("section");
        gen.addSimpleField(Integer.class, "ordinal");
        gen.addFetchedField(IEntityType.class, "entityType", "Entity type", EntityTypeFetchOptions.class);
        gen.addFetchedField(PropertyType.class, "propertyType", "Property type", PropertyTypeFetchOptions.class).withInterface(IPropertyTypeHolder.class);
        gen.addBooleanField("mandatory");
        gen.addBooleanField("showInEditView");
        gen.addBooleanField("showRawValueInForms");
        Generator.addSemanticAnnotations(gen);
        DtoGenerator.DTOField inherited = gen.addFetchedField(Boolean.class, "semanticAnnotationsInherited", "Semantic annotations", SemanticAnnotationFetchOptions.class, "semanticAnnotations");
        inherited.plural = true;
        Generator.addRegistrator(gen);
        Generator.addRegistrationDate(gen);
        gen.setToStringMethod("\"PropertyAssignment entity type: \" + (entityType != null ? entityType.getCode() : null) + \", property type: \" + (propertyType != null ? propertyType.getCode() : null) + \", mandatory: \" + mandatory");
        return gen;
    }

    private static DtoGenerator createPropertyTypeGenerator() {
        DtoGenerator gen = new DtoGenerator("property", "PropertyType", PropertyTypeFetchOptions.class);
        Generator.addCode(gen);
        Generator.addPermId(gen, PropertyTypePermId.class);
        gen.addStringField("label");
        Generator.addDescription(gen);
        gen.addBooleanField("managedInternally");
        gen.addSimpleField(DataType.class, "dataType");
        gen.addFetchedField(Vocabulary.class, "vocabulary", "Vocabulary", VocabularyFetchOptions.class);
        gen.addFetchedField(MaterialType.class, "materialType", "Material type", MaterialTypeFetchOptions.class);
        gen.addStringField("schema");
        gen.addStringField("transformation");
        Generator.addSemanticAnnotations(gen);
        Generator.addRegistrator(gen);
        Generator.addRegistrationDate(gen);
        gen.setToStringMethod("\"PropertyType \" + code");
        return gen;
    }

    private static DtoGenerator createOperationExecution() {
        DtoGenerator gen = new DtoGenerator("operation", "OperationExecution", OperationExecutionFetchOptions.class);
        Generator.addPermId(gen, OperationExecutionPermId.class);
        Generator.addCode(gen);
        gen.addSimpleField(OperationExecutionState.class, "state");
        gen.addFetchedField(Person.class, "owner", "Owner", PersonFetchOptions.class);
        Generator.addDescription(gen);
        gen.addFetchedField(IOperationExecutionNotification.class, "notification", "Notification", OperationExecutionNotificationFetchOptions.class);
        gen.addSimpleField(OperationExecutionAvailability.class, "availability");
        gen.addSimpleField(Integer.class, "availabilityTime");
        gen.addFetchedField(OperationExecutionSummary.class, "summary", "Summary", OperationExecutionSummaryFetchOptions.class);
        gen.addSimpleField(OperationExecutionAvailability.class, "summaryAvailability");
        gen.addSimpleField(Integer.class, "summaryAvailabilityTime");
        gen.addFetchedField(OperationExecutionDetails.class, "details", "Details", OperationExecutionDetailsFetchOptions.class);
        gen.addSimpleField(OperationExecutionAvailability.class, "detailsAvailability");
        gen.addSimpleField(Integer.class, "detailsAvailabilityTime");
        gen.addSimpleField(Date.class, "creationDate");
        gen.addSimpleField(Date.class, "startDate");
        gen.addSimpleField(Date.class, "finishDate");
        gen.setToStringMethod("\"OperationExecution code: \" + code");
        return gen;
    }

    private static DtoGenerator createOperationExecutionSummary() {
        DtoGenerator gen = new DtoGenerator("operation", "OperationExecutionSummary", OperationExecutionSummaryFetchOptions.class);
        gen.addPluralFetchedField("List<String>", List.class.getName(), "operations", "Operations", EmptyFetchOptions.class);
        gen.addFetchedField(String.class, "progress", "Progress", EmptyFetchOptions.class);
        gen.addFetchedField(String.class, "error", "Error", EmptyFetchOptions.class);
        gen.addPluralFetchedField("List<String>", List.class.getName(), "results", "Results", EmptyFetchOptions.class);
        gen.setToStringMethod("\"OperationExecutionSummary\"");
        return gen;
    }

    private static DtoGenerator createOperationExecutionDetails() {
        DtoGenerator gen = new DtoGenerator("operation", "OperationExecutionDetails", OperationExecutionDetailsFetchOptions.class);
        gen.addClassForImport(IOperation.class);
        gen.addClassForImport(IOperationResult.class);
        gen.addPluralFetchedField("List<? extends IOperation>", List.class.getName(), "operations", "Operations", EmptyFetchOptions.class);
        gen.addFetchedField(IOperationExecutionProgress.class, "progress", "Progress", EmptyFetchOptions.class);
        gen.addFetchedField(IOperationExecutionError.class, "error", "Error", EmptyFetchOptions.class);
        gen.addPluralFetchedField("List<? extends IOperationResult>", List.class.getName(), "results", "Results", EmptyFetchOptions.class);
        gen.setToStringMethod("\"OperationExecutionDetails\"");
        return gen;
    }

    private static DtoGenerator createSemanticAnnotation() {
        DtoGenerator gen = new DtoGenerator("semanticannotation", "SemanticAnnotation", SemanticAnnotationFetchOptions.class);
        gen.addFetchedField(IEntityType.class, "entityType", "Entity type", EntityTypeFetchOptions.class);
        gen.addFetchedField(PropertyType.class, "propertyType", "Property type", PropertyTypeFetchOptions.class);
        gen.addFetchedField(PropertyAssignment.class, "propertyAssignment", "Property assignment", PropertyAssignmentFetchOptions.class);
        Generator.addPermId(gen, SemanticAnnotationPermId.class);
        gen.addSimpleField(String.class, "predicateOntologyId");
        gen.addSimpleField(String.class, "predicateOntologyVersion");
        gen.addSimpleField(String.class, "predicateAccessionId");
        gen.addSimpleField(String.class, "descriptorOntologyId");
        gen.addSimpleField(String.class, "descriptorOntologyVersion");
        gen.addSimpleField(String.class, "descriptorAccessionId");
        gen.addSimpleField(Date.class, "creationDate");
        gen.setToStringMethod("\"SemanticAnnotation \" + permId");
        return gen;
    }

    private static DtoGenerator createQuery() {
        DtoGenerator gen = new DtoGenerator("query", "Query", QueryFetchOptions.class);
        gen.addSimpleField(String.class, "name");
        Generator.addDescription(gen);
        gen.addSimpleField(String.class, "database");
        gen.addSimpleField(QueryType.class, "queryType");
        gen.addSimpleField(String.class, "entityTypeCodePattern");
        gen.addSimpleField(String.class, "sql");
        gen.addSimpleField(Boolean.TYPE, "public");
        Generator.addRegistrationDate(gen);
        Generator.addRegistrator(gen);
        Generator.addModificationDate(gen);
        gen.setToStringMethod("\"Query \" + name");
        return gen;
    }

    private static DtoGenerator createQueryDatabase() {
        DtoGenerator gen = new DtoGenerator("query", "QueryDatabase", QueryDatabaseFetchOptions.class);
        Generator.addPermId(gen, QueryDatabaseName.class);
        gen.addSimpleField(String.class, "name");
        gen.addSimpleField(String.class, "label");
        Generator.addSpace(gen);
        gen.addSimpleField(Role.class, "creatorMinimalRole");
        gen.addSimpleField(RoleLevel.class, "creatorMinimalRoleLevel");
        gen.setToStringMethod("\"QueryDatabase \" + name");
        return gen;
    }

    public static void main(String[] args) throws FileNotFoundException {
        LinkedList<DtoGenerator> list = new LinkedList<DtoGenerator>();
        list.add(Generator.createDataSetGenerator());
        list.add(Generator.createDataSetTypeGenerator());
        list.add(Generator.createAttachmentGenerator());
        list.add(Generator.createExperimentGenerator());
        list.add(Generator.createExperimentTypeGenerator());
        list.add(Generator.createPersonGenerator());
        list.add(Generator.createProjectGenerator());
        list.add(Generator.createSampleGenerator());
        list.add(Generator.createSampleTypeGenerator());
        list.add(Generator.createSpaceGenerator());
        list.add(Generator.createTagGenerator());
        list.add(Generator.createMaterialGenerator());
        list.add(Generator.createMaterialTypeGenerator());
        list.add(Generator.createVocabularyTerm());
        list.add(Generator.createVocabulary());
        list.add(Generator.createLocatorType());
        list.add(Generator.createFileFormatType());
        list.add(Generator.createStorageFormat());
        list.add(Generator.createPhysicalDataGenerator());
        list.add(Generator.createLinkedDataGenerator());
        list.add(Generator.createHistoryEntryGenerator());
        list.add(Generator.createDeletion());
        list.add(Generator.createDataStoreGenerator());
        list.add(Generator.createExternalDmsGenerator());
        list.add(Generator.createCustomASServiceGenerator());
        list.add(Generator.createObjectKindModificationGenerator());
        list.add(Generator.createGlobalSearchObject());
        list.add(Generator.createPropertyAssignmentGenerator());
        list.add(Generator.createPropertyTypeGenerator());
        list.add(Generator.createOperationExecution());
        list.add(Generator.createOperationExecutionSummary());
        list.add(Generator.createOperationExecutionDetails());
        list.add(Generator.createSemanticAnnotation());
        list.add(Generator.createQuery());
        list.add(Generator.createQueryDatabase());
        list.add(Generator.createEvent());
        for (DtoGenerator gen : list) {
            System.out.print("Generating api classes for " + gen + "...");
            gen.generateDTO();
            gen.generateFetchOptions();
            System.out.println("done");
        }
    }
}

