/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.generators;

import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.generators.uglify.UglifyJS;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.generators.uglify.UglifyOptions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;

public class UltimateJSEntityGenerator {
    private static final String API_PROJECT_ROOT_FOLDER = "/Users/fedoreno/projects/work/openbis";
    private static final String API_PROJECT_SOURCE_FOLDER = "/Users/fedoreno/projects/work/openbis/openbis_api/source/java/";
    private static final String JSTEST_PROJECT_SOURCE_FOLDER = "/Users/fedoreno/projects/work/openbis/js-test/servers/common/core-plugins/tests/1/as/webapps/openbis-v3-api-test/html/dto/";
    private static final String[] CLASSES_TO_CONVERT = new String[]{"ch.ethz.sis.openbis.generic.shared.api.v3.dto.entity.experiment.ExperimentUpdate"};

    public static void main(String[] args) throws IOException {
        for (String classToConvert : CLASSES_TO_CONVERT) {
            String javaClass = UltimateJSEntityGenerator.readFileAsString(API_PROJECT_SOURCE_FOLDER + classToConvert.replace('.', '/') + ".java");
            String jsClass = UltimateJSEntityGenerator.translateFromJavaToJS(javaClass);
            System.out.println(jsClass);
            System.out.println(UltimateJSEntityGenerator.prettyPrint(jsClass));
        }
    }

    private static final String translateFromJavaToJS(String toTranslate) {
        return toTranslate.replaceAll("package.+;", "").replaceAll("import.+;", "").replaceAll("@JsonObject.+\\)", "").replaceAll("@JsonProperty", "").replaceAll("@JsonIgnore", "").replaceAll("@Override", "").replaceAll("private static final long serialVersionUID.+;", "").replaceAll("<[\\w, ]+>", "").replaceAll("<[\\w, ]+>", "").replaceAll("\\[\\]", "").replaceAll("private\\s+\\w+\\s+", "var _").replaceAll("this.", "_").replaceAll("public class ([\\w]+)\\s*(?:implements Serializable)?\\s*[\\n\\s]*\\{", "function $1()\n{\n\tthis['@type'] = '$1';").replaceAll("public [\\w\\[\\]]+ ", "function ").replaceAll("function (\\w+)\\([\\w\\[\\]]+ ", "function $1(").replaceAll("function fetch(\\w+)\\(((\\w+))\\)", "function setFetch$1($2)").replaceAll("throw new .+\\(\"(.+)\"\\);", "throw '$1';").replaceAll("([\\w]+)\\s*==\\s*null", "!$1").replaceAll("([\\w]+)\\s*!=\\s*null", "$1").replaceAll("==", "===").replaceAll("!=", "!==").replaceAll("(?:/\\*(?:[^*]|(?:\\*+[^*/]))*\\*+/)|(?://.*)", "");
    }

    private static final void whriteStringAsFile(String filePath, String string) throws IOException {
        try (Writer out = null;){
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
            out.write(string);
        }
    }

    private static final String readFileAsString(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF8"));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
        }
        reader.close();
        return fileData.toString();
    }

    private static String prettyPrint(String jsClass) throws IOException {
        UglifyOptions options = new UglifyOptions();
        options.beautify = true;
        options.noMangle = true;
        options.noSqueeze = true;
        options.noSeqs = true;
        ArrayList<String> optionsArgList = options.toArgList();
        File temp = File.createTempFile("temp", "");
        UltimateJSEntityGenerator.whriteStringAsFile(temp.getAbsolutePath(), jsClass);
        optionsArgList.add(temp.getAbsolutePath());
        String[] args = new String[optionsArgList.size()];
        args = optionsArgList.toArray(args);
        UglifyJS uglifyjs = new UglifyJS();
        return uglifyjs.uglify(args);
    }
}

