/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.globalsearch;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortParameter;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.GlobalSearchObject;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.fetchoptions.GlobalSearchObjectSortOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.globalsearch.ObjectIdentifierComparator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.globalsearch.ObjectKindComparator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.globalsearch.ObjectPermIdComparator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.globalsearch.ScoreComparator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort.ComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort.CompositeComparator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class GlobalSearchObjectComparatorFactory
extends ComparatorFactory {
    @Override
    public boolean accepts(Class<?> sortOptionsClass) {
        return GlobalSearchObjectSortOptions.class.isAssignableFrom(sortOptionsClass);
    }

    @Override
    public Comparator<GlobalSearchObject> getComparator(String field, Map<SortParameter, String> parameters, ISearchCriteria criteria) {
        if ("SCORE".equals(field)) {
            return new ScoreComparator();
        }
        if ("OBJECT_KIND".equals(field)) {
            return new ObjectKindComparator();
        }
        if ("OBJECT_PERM_ID".equals(field)) {
            return new ObjectPermIdComparator();
        }
        if ("OBJECT_IDENTIFIER".equals(field)) {
            return new ObjectIdentifierComparator();
        }
        return null;
    }

    @Override
    public Comparator<GlobalSearchObject> getDefaultComparator() {
        return new CompositeComparator<GlobalSearchObject>(Collections.reverseOrder(new ScoreComparator()), new ObjectKindComparator(), new ObjectIdentifierComparator());
    }
}

