/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.material;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.id.MaterialPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.AbstractListObjectById;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IMaterialDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import java.util.HashSet;
import java.util.List;

public class ListMaterialsByPermId
extends AbstractListObjectById<MaterialPermId, MaterialPE> {
    private IMaterialDAO materialDAO;

    public ListMaterialsByPermId(IMaterialDAO materialDAO) {
        this.materialDAO = materialDAO;
    }

    @Override
    public Class<MaterialPermId> getIdClass() {
        return MaterialPermId.class;
    }

    @Override
    public MaterialPermId createId(MaterialPE material) {
        return new MaterialPermId(material.getCode(), material.getMaterialType().getCode());
    }

    @Override
    public List<MaterialPE> listByIds(IOperationContext context, List<MaterialPermId> ids) {
        System.out.println("list by ids: " + ids);
        HashSet<MaterialIdentifier> codes = new HashSet<MaterialIdentifier>();
        for (MaterialPermId id : ids) {
            codes.add(new MaterialIdentifier(id.getCode(), id.getTypeCode()));
        }
        return this.materialDAO.listMaterialsByMaterialIdentifier(codes);
    }
}

