/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.material;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.id.MaterialPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.AbstractListTechIdById;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.TechIdStringIdentifierRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.material.MaterialQuery;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.QueryTool;

public class ListMaterialsTechIdByPermId
extends AbstractListTechIdById<MaterialPermId> {
    @Override
    public Class<MaterialPermId> getIdClass() {
        return MaterialPermId.class;
    }

    @Override
    protected Map<Long, MaterialPermId> createIdsByTechIdsMap(IOperationContext context, List<MaterialPermId> ids) {
        HashMap<String, HashMap<String, MaterialPermId>> groupedIdentifiers = new HashMap<String, HashMap<String, MaterialPermId>>();
        for (MaterialPermId permId : ids) {
            String code = CodeConverter.tryToDatabase(permId.getCode());
            String typeCode = CodeConverter.tryToDatabase(permId.getTypeCode());
            HashMap<String, MaterialPermId> identifiersByCode = (HashMap<String, MaterialPermId>)groupedIdentifiers.get(typeCode);
            if (identifiersByCode == null) {
                identifiersByCode = new HashMap<String, MaterialPermId>();
                groupedIdentifiers.put(typeCode, identifiersByCode);
            }
            identifiersByCode.put(code, permId);
        }
        HashMap<Long, MaterialPermId> result = new HashMap<Long, MaterialPermId>();
        MaterialQuery query = (MaterialQuery)QueryTool.getManagedQuery(MaterialQuery.class);
        Set entrySet = groupedIdentifiers.entrySet();
        for (Map.Entry entry : entrySet) {
            String typeCode = (String)entry.getKey();
            Map identifiersByCode = (Map)entry.getValue();
            Set codes = identifiersByCode.keySet();
            String[] codesAsArray = codes.toArray(new String[codes.size()]);
            for (TechIdStringIdentifierRecord record : query.listMaterialTechIdsByCodes(typeCode, codesAsArray)) {
                result.put(record.id, (MaterialPermId)identifiersByCode.get(record.identifier));
            }
        }
        return result;
    }
}

