/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.person;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.Me;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.AbstractListObjectById;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.Collections;
import java.util.List;

public class ListPersonByMe
extends AbstractListObjectById<Me, PersonPE> {
    private IPersonDAO personDAO;

    public ListPersonByMe(IPersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    @Override
    public Me createId(PersonPE entity) {
        return new Me();
    }

    @Override
    public List<PersonPE> listByIds(IOperationContext context, List<Me> ids) {
        PersonPE person = context.getSession().tryGetPerson();
        if (person == null) {
            throw new UserFailureException("Can not resolve 'Me' because there is no session user.");
        }
        PersonPE reloadedPerson = (PersonPE)this.personDAO.getByTechId(TechId.create((IIdHolder)person));
        return Collections.nCopies(ids.size(), reloadedPerson);
    }

    @Override
    protected Class<Me> getIdClass() {
        return Me.class;
    }
}

