/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.plugin;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.id.PluginPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.AbstractListObjectById;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IScriptDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import java.util.ArrayList;
import java.util.List;

public class ListPluginByPermId
extends AbstractListObjectById<PluginPermId, ScriptPE> {
    private IScriptDAO scriptDAO;

    public ListPluginByPermId(IScriptDAO scriptDAO) {
        this.scriptDAO = scriptDAO;
    }

    @Override
    public Class<PluginPermId> getIdClass() {
        return PluginPermId.class;
    }

    @Override
    public PluginPermId createId(ScriptPE plugin) {
        return new PluginPermId(plugin.getName());
    }

    @Override
    public List<ScriptPE> listByIds(IOperationContext context, List<PluginPermId> ids) {
        ArrayList<ScriptPE> plugins = new ArrayList<ScriptPE>();
        for (PluginPermId id : ids) {
            ScriptPE plugin = this.scriptDAO.tryFindByName(id.getPermId());
            if (plugin == null) continue;
            plugins.add(plugin);
        }
        return plugins;
    }
}

