/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.project;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.AbstractListTechIdById;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.TechIdStringIdentifierRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.project.ProjectQuery;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.QueryTool;

public class ListProjectTechIdByIdentifier
extends AbstractListTechIdById<ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier> {
    @Override
    public Class<ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier> getIdClass() {
        return ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier.class;
    }

    @Override
    protected Map<Long, ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier> createIdsByTechIdsMap(IOperationContext context, List<ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier> ids) {
        Map identifiersByCode;
        HashMap groupedIdentifiers = new HashMap();
        for (ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier projectIdentifier : ids) {
            ProjectIdentifier projectIdentifier2 = ProjectIdentifierFactory.parse(projectIdentifier.getIdentifier());
            String spaceCode = CodeConverter.tryToDatabase(projectIdentifier2.getSpaceCode());
            String projectCode = CodeConverter.tryToDatabase(projectIdentifier2.getProjectCode());
            identifiersByCode = (HashMap<String, ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier>)groupedIdentifiers.get(spaceCode);
            if (identifiersByCode == null) {
                identifiersByCode = new HashMap<String, ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier>();
                groupedIdentifiers.put(spaceCode, identifiersByCode);
            }
            identifiersByCode.put(projectCode, projectIdentifier);
        }
        HashMap<Long, ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier> result = new HashMap<Long, ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier>();
        ProjectQuery query = (ProjectQuery)QueryTool.getManagedQuery(ProjectQuery.class);
        for (Map.Entry entry : groupedIdentifiers.entrySet()) {
            String spaceCode = (String)entry.getKey();
            identifiersByCode = (Map)entry.getValue();
            Set codes = identifiersByCode.keySet();
            String[] codesAsArray = codes.toArray(new String[codes.size()]);
            for (TechIdStringIdentifierRecord record : query.listProjectTechIdsByCodes(spaceCode, codesAsArray)) {
                result.put(record.id, (ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier)identifiersByCode.get(record.identifier));
            }
        }
        return result;
    }
}

