/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortParameter;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyAssignment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.fetchoptions.PropertyAssignmentSortOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort.AbstractComparator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort.AbstractStringComparator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort.ComparatorFactory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class PropertyAssignmentComparatorFactory
extends ComparatorFactory {
    private static final Map<String, Comparator<?>> COMPARATORS_BY_FIELD = new HashMap();

    @Override
    public boolean accepts(Class<?> sortOptionsClass) {
        return PropertyAssignmentSortOptions.class.isAssignableFrom(sortOptionsClass);
    }

    @Override
    public Comparator<?> getComparator(String field, Map<SortParameter, String> parameters, ISearchCriteria criteria) {
        return COMPARATORS_BY_FIELD.get(field);
    }

    @Override
    public Comparator<?> getDefaultComparator() {
        return this.getComparator("ORDINAL", null, null);
    }

    static {
        COMPARATORS_BY_FIELD.put("ORDINAL", new AbstractComparator<PropertyAssignment, Integer>(){

            @Override
            protected Integer getValue(PropertyAssignment propertyAssignment) {
                return propertyAssignment.getOrdinal();
            }
        });
        COMPARATORS_BY_FIELD.put("CODE", new AbstractPropertyAssignmentComparator(){

            @Override
            protected String getValue(PropertyType propertyType) {
                return propertyType.getCode();
            }
        });
        COMPARATORS_BY_FIELD.put("LABEL", new AbstractPropertyAssignmentComparator(){

            @Override
            protected String getValue(PropertyType propertyType) {
                return propertyType.getLabel();
            }
        });
    }

    private static abstract class AbstractPropertyAssignmentComparator
    extends AbstractStringComparator<PropertyAssignment> {
        private AbstractPropertyAssignmentComparator() {
        }

        @Override
        protected String getValue(PropertyAssignment assignment) {
            PropertyType propertyType = assignment.getPropertyType();
            String v = propertyType == null ? null : this.getValue(propertyType);
            return v == null ? "" : v;
        }

        @Override
        protected abstract String getValue(PropertyType var1);
    }
}

