/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.roleassignment;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;

public class RoleAssignmentUtils {
    public static void checkForSelfreducingAdminAuthorization(RoleAssignmentPE roleAssignment, PersonPE personPE) {
        if (roleAssignment.getPerson() != null && roleAssignment.getPerson().equals(personPE) && roleAssignment.getRole().equals((Object)RoleWithHierarchy.RoleCode.ADMIN)) {
            boolean isInstanceAdmin = RoleAssignmentUtils.isInstanceAdmin(personPE);
            if (!isInstanceAdmin) {
                String adminType = "space";
                ProjectPE project = roleAssignment.getProject();
                if (project != null) {
                    if (RoleAssignmentUtils.isSpaceAdmin(personPE, project.getSpace())) {
                        return;
                    }
                    adminType = "project";
                }
                throw new UserFailureException("For safety reason you cannot give away your own " + adminType + " admin power. Ask " + (adminType.equals("project") ? "space or " : "") + "instance admin to do that for you.");
            }
            if (roleAssignment.getSpace() == null && roleAssignment.getProject() == null) {
                throw new UserFailureException("For safety reason you cannot give away your own omnipotence. Ask another instance admin to do that for you.");
            }
        }
    }

    public static boolean isInstanceAdmin(PersonPE personPE) {
        for (RoleAssignmentPE roleAssigment : personPE.getRoleAssignments()) {
            if (roleAssigment.getSpace() != null || roleAssigment.getProject() != null || !roleAssigment.getRole().equals((Object)RoleWithHierarchy.RoleCode.ADMIN)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSpaceAdmin(PersonPE personPE, SpacePE spacePE) {
        for (RoleAssignmentPE roleAssigment : personPE.getRoleAssignments()) {
            if (!spacePE.equals(roleAssigment.getSpace()) || !roleAssigment.getRole().equals((Object)RoleWithHierarchy.RoleCode.ADMIN)) continue;
            return true;
        }
        return false;
    }
}

