/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.SampleIdentifierParts;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class FullSampleIdentifier {
    private static final String CODE_CHAR_PATTERN = "a-zA-Z0-9_\\-\\.";
    private static final String CODE_CHARS = "[a-zA-Z0-9_\\-\\.]+";
    private static final String CODE_PATTERN = "^[a-zA-Z0-9_\\-\\.]+$";
    private SampleIdentifierParts sampleIdentifierParts;
    private String sampleCode;

    public FullSampleIdentifier(String sampleIdentifier, String homeSpaceCodeOrNull) {
        List<String> splittedCode;
        String[] parts = this.extractParts(sampleIdentifier);
        String spaceCode = null;
        String projectCode = null;
        String containerCode = null;
        String plainSampleCode = null;
        String code = null;
        if (parts.length == 2) {
            code = parts[1];
        } else if (parts.length == 3) {
            spaceCode = parts[1];
            code = parts[2];
        } else {
            spaceCode = parts[1];
            projectCode = parts[2];
            code = parts[3];
        }
        if (spaceCode != null && spaceCode.isEmpty() && homeSpaceCodeOrNull != null) {
            spaceCode = homeSpaceCodeOrNull;
        }
        if ((splittedCode = this.splitCode(code, sampleIdentifier)).size() == 2) {
            containerCode = splittedCode.get(0);
            plainSampleCode = splittedCode.get(1);
        } else {
            plainSampleCode = splittedCode.get(0);
        }
        this.verifyCodePattern(spaceCode, "Space code");
        this.verifyCodePattern(projectCode, "Project code");
        this.verifyCodePattern(containerCode, "Container sample code");
        this.verifyCodePattern(plainSampleCode, containerCode == null ? "Sample code" : "Sample subcode");
        this.sampleCode = CodeConverter.tryToDatabase(plainSampleCode);
        this.sampleIdentifierParts = new SampleIdentifierParts(CodeConverter.tryToDatabase(spaceCode), CodeConverter.tryToDatabase(projectCode), CodeConverter.tryToDatabase(containerCode));
    }

    private List<String> splitCode(String code, String sampleIdentifier) {
        String delim = ":";
        StringTokenizer tokenizer = new StringTokenizer(code, delim, true);
        int numberOfDelims = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (delim.equals(token)) {
                ++numberOfDelims;
                continue;
            }
            tokens.add(token);
        }
        if (numberOfDelims > 1) {
            throw new IllegalArgumentException("Sample code can not contain more than one '" + delim + "': " + sampleIdentifier);
        }
        if (numberOfDelims != tokens.size() - 1) {
            throw new IllegalArgumentException("Sample code starts or ends with '" + delim + "': " + sampleIdentifier);
        }
        return tokens;
    }

    private String[] extractParts(String sampleIdentifier) {
        if (StringUtils.isBlank((CharSequence)sampleIdentifier)) {
            throw new IllegalArgumentException("Unspecified sample identifier.");
        }
        if (!sampleIdentifier.startsWith("/")) {
            throw new IllegalArgumentException("Sample identifier has to start with a '/': " + sampleIdentifier);
        }
        String[] parts = sampleIdentifier.split("/");
        if (parts.length == 0) {
            throw new IllegalArgumentException("Sample identifier don't contain any codes: " + sampleIdentifier);
        }
        if (parts.length > 4) {
            throw new IllegalArgumentException("Sample identifier can not contain more than three '/': " + sampleIdentifier);
        }
        return parts;
    }

    private void verifyCodePattern(String code, String partName) {
        if (code == null) {
            return;
        }
        if (code.length() == 0) {
            throw new IllegalArgumentException(partName + " can not be an empty string.");
        }
        if (!code.matches(CODE_PATTERN)) {
            throw new IllegalArgumentException(partName + " containing other characters than letters, numbers, '_', '-' and '.': " + code);
        }
    }

    public SampleIdentifierParts getParts() {
        return this.sampleIdentifierParts;
    }

    public String getSampleCode() {
        return this.sampleCode;
    }

    public String toString() {
        return new SampleIdentifier(this.sampleIdentifierParts.getSpaceCodeOrNull(), this.sampleIdentifierParts.getProjectCodeOrNull(), this.sampleIdentifierParts.getContainerCodeOrNull(), this.sampleCode).toString();
    }
}

