/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.AbstractListTechIdById;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.TechIdStringIdentifierRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.FullSampleIdentifier;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.SampleIdentifierParts;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.SampleQuery;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lemnik.eodsql.QueryTool;

public class ListSampleTechIdByIdentifier
extends AbstractListTechIdById<SampleIdentifier> {
    public static final String CONTAINER_SHORTCUT_ALLOWED_ATTRIBUTE = "container-shortcut-allowed";
    private String homeSpaceCodeOrNull;

    public ListSampleTechIdByIdentifier(String homeSpaceCodeOrNull) {
        this.homeSpaceCodeOrNull = homeSpaceCodeOrNull;
    }

    @Override
    public Class<SampleIdentifier> getIdClass() {
        return SampleIdentifier.class;
    }

    @Override
    protected Map<Long, SampleIdentifier> createIdsByTechIdsMap(IOperationContext context, List<SampleIdentifier> ids) {
        Map<SampleIdentifierParts, Map<String, SampleIdentifier>> groupedIdentifiers = this.groupIdentifiers(ids);
        boolean containerShortcutAllowed = this.getContainerShortcutAllowed(context);
        HashMap<Long, SampleIdentifier> result = new HashMap<Long, SampleIdentifier>();
        SampleQuery query = (SampleQuery)QueryTool.getManagedQuery(SampleQuery.class);
        for (Map.Entry<SampleIdentifierParts, Map<String, SampleIdentifier>> entry : groupedIdentifiers.entrySet()) {
            SampleIdentifierParts key = entry.getKey();
            Map<String, SampleIdentifier> identifiersByCode = entry.getValue();
            List<TechIdStringIdentifierRecord> records = this.list(query, key, identifiersByCode.keySet(), containerShortcutAllowed);
            for (TechIdStringIdentifierRecord record : records) {
                String sampleCode = record.identifier;
                result.put(record.id, identifiersByCode.get(sampleCode));
            }
        }
        return result;
    }

    private boolean getContainerShortcutAllowed(IOperationContext context) {
        Object value = context.getAttribute(CONTAINER_SHORTCUT_ALLOWED_ATTRIBUTE);
        return Boolean.TRUE.equals(value);
    }

    private Map<SampleIdentifierParts, Map<String, SampleIdentifier>> groupIdentifiers(List<SampleIdentifier> ids) {
        HashMap<SampleIdentifierParts, Map<String, SampleIdentifier>> groupedIdentifiers = new HashMap<SampleIdentifierParts, Map<String, SampleIdentifier>>();
        for (SampleIdentifier sampleIdentifier : ids) {
            FullSampleIdentifier fullSampleIdentifier = new FullSampleIdentifier(sampleIdentifier.getIdentifier(), this.homeSpaceCodeOrNull);
            SampleIdentifierParts key = fullSampleIdentifier.getParts();
            HashMap<String, SampleIdentifier> identifiersByCode = (HashMap<String, SampleIdentifier>)groupedIdentifiers.get(key);
            if (identifiersByCode == null) {
                identifiersByCode = new HashMap<String, SampleIdentifier>();
                groupedIdentifiers.put(key, identifiersByCode);
            }
            identifiersByCode.put(fullSampleIdentifier.getSampleCode(), sampleIdentifier);
        }
        return groupedIdentifiers;
    }

    private List<TechIdStringIdentifierRecord> list(final SampleQuery query, SampleIdentifierParts key, Collection<String> codes, boolean containerShortcutAllowed) {
        String[] codesArray = codes.toArray(new String[codes.size()]);
        final String spaceCode = key.getSpaceCodeOrNull();
        final String projectCode = key.getProjectCodeOrNull();
        String containerCode = key.getContainerCodeOrNull();
        if (spaceCode == null) {
            if (containerCode == null) {
                return this.listWithoutContainerOrWithSomeContainerAndUniqueCode(query, codesArray, new IListAction(){

                    @Override
                    public List<TechIdStringIdentifierRecord> list(String[] codesToList) {
                        return query.listSharedSampleTechIdsByCodesWithoutContainer(codesToList);
                    }
                }, new IListAction(){

                    @Override
                    public List<TechIdStringIdentifierRecord> list(String[] codesToList) {
                        return query.listSharedSampleTechIdsByCodesWithSomeContainer(codesToList);
                    }
                }, containerShortcutAllowed);
            }
            return query.listSharedSampleTechIdsByContainerCodeAndCodes(containerCode, codesArray);
        }
        if (projectCode == null) {
            if (containerCode == null) {
                return this.listWithoutContainerOrWithSomeContainerAndUniqueCode(query, codesArray, new IListAction(){

                    @Override
                    public List<TechIdStringIdentifierRecord> list(String[] codesToList) {
                        return query.listSpaceSampleTechIdsByCodesWithoutContainer(spaceCode, codesToList);
                    }
                }, new IListAction(){

                    @Override
                    public List<TechIdStringIdentifierRecord> list(String[] codesToList) {
                        return query.listSpaceSampleTechIdsByCodesWithSomeContainer(spaceCode, codesToList);
                    }
                }, containerShortcutAllowed);
            }
            return query.listSpaceSampleTechIdsByContainerCodeAndCodes(spaceCode, containerCode, codesArray);
        }
        if (containerCode == null) {
            return this.listWithoutContainerOrWithSomeContainerAndUniqueCode(query, codesArray, new IListAction(){

                @Override
                public List<TechIdStringIdentifierRecord> list(String[] codesToList) {
                    return query.listProjectSampleTechIdsByCodesWithoutContainer(spaceCode, projectCode, codesToList);
                }
            }, new IListAction(){

                @Override
                public List<TechIdStringIdentifierRecord> list(String[] codesToList) {
                    return query.listProjectSampleTechIdsByCodesWithSomeContainer(spaceCode, projectCode, codesToList);
                }
            }, containerShortcutAllowed);
        }
        return query.listProjectSampleTechIdsByContainerCodeAndCodes(spaceCode, projectCode, containerCode, codesArray);
    }

    private List<TechIdStringIdentifierRecord> listWithoutContainerOrWithSomeContainerAndUniqueCode(SampleQuery query, String[] codes, IListAction listWithoutContainer, IListAction listWithSomeContainer, boolean containerShortcutAllowed) {
        try {
            List<TechIdStringIdentifierRecord> foundWithoutContainer = listWithoutContainer.list(codes);
            HashSet<String> codesNotFound = new HashSet<String>(Arrays.asList(codes));
            for (TechIdStringIdentifierRecord found : foundWithoutContainer) {
                codesNotFound.remove(found.identifier);
            }
            if (codesNotFound.isEmpty() || !containerShortcutAllowed) {
                return foundWithoutContainer;
            }
            LinkedList<TechIdStringIdentifierRecord> allFound = new LinkedList<TechIdStringIdentifierRecord>(foundWithoutContainer);
            List<TechIdStringIdentifierRecord> foundWithSomeContainer = listWithSomeContainer.list(codesNotFound.toArray(new String[0]));
            HashMap<String, TechIdStringIdentifierRecord> foundWithSomeContainerMap = new HashMap<String, TechIdStringIdentifierRecord>();
            HashMap<String, Integer> foundWithSomeContainerCounter = new HashMap<String, Integer>();
            for (TechIdStringIdentifierRecord techIdStringIdentifierRecord : foundWithSomeContainer) {
                foundWithSomeContainerMap.put(techIdStringIdentifierRecord.identifier, techIdStringIdentifierRecord);
                Integer counter = (Integer)foundWithSomeContainerCounter.get(techIdStringIdentifierRecord.identifier);
                counter = counter == null ? 1 : counter + 1;
                foundWithSomeContainerCounter.put(techIdStringIdentifierRecord.identifier, counter);
            }
            for (Map.Entry entry : foundWithSomeContainerCounter.entrySet()) {
                if ((Integer)entry.getValue() != 1) continue;
                TechIdStringIdentifierRecord found = (TechIdStringIdentifierRecord)foundWithSomeContainerMap.get(entry.getKey());
                allFound.add(found);
            }
            return allFound;
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }

    private static interface IListAction {
        public List<TechIdStringIdentifierRecord> list(String[] var1);
    }
}

