/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.service;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.CustomASServiceExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.plugin.service.IImportService;
import ch.ethz.sis.openbis.generic.asapi.v3.plugin.service.context.ServiceContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.service.IScriptRunnerFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.service.IServiceScriptRunner;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ExceptionUtils;
import ch.systemsx.cisd.common.jython.JythonUtils;
import ch.systemsx.cisd.common.jython.evaluator.Evaluator;
import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.common.jython.evaluator.IJythonEvaluator;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.Serializable;
import org.apache.log4j.Logger;

class CustomASServiceScriptRunnerFactory
implements IScriptRunnerFactory {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, CustomASServiceScriptRunnerFactory.class);
    private final String scriptPath;
    private final IApplicationServerApi applicationService;
    private final IImportService importService;

    public CustomASServiceScriptRunnerFactory(String scriptPath, IApplicationServerApi applicationService, IImportService importService) {
        this.scriptPath = scriptPath;
        this.applicationService = applicationService;
        this.importService = importService;
        Evaluator.getFactory().initialize();
    }

    @Override
    public String getScriptPath() {
        return this.scriptPath;
    }

    @Override
    public IServiceScriptRunner createServiceRunner(ServiceContext context) {
        String scriptString = JythonUtils.extractScriptFromPath((String)this.scriptPath);
        String[] pythonPath = JythonUtils.getScriptDirectoryPythonPath((String[])new String[]{this.scriptPath});
        try {
            IJythonEvaluator evaluator = Evaluator.getFactory().create("", pythonPath, this.scriptPath, null, scriptString, false);
            String sessionToken = context.getSessionToken();
            ExecutionContext executionContext = new ExecutionContext(sessionToken, this.applicationService, this.importService);
            return new ServiceScriptRunner(evaluator, executionContext);
        }
        catch (EvaluatorException ex) {
            throw new EvaluatorException(ex.getMessage() + " [" + this.scriptPath + "]");
        }
    }

    public static final class ExecutionContext {
        private final String sessionToken;
        private final IApplicationServerApi applicationService;
        private final IImportService importService;

        ExecutionContext(String sessionToken, IApplicationServerApi applicationService, IImportService importService) {
            this.sessionToken = sessionToken;
            this.applicationService = applicationService;
            this.importService = importService;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public IApplicationServerApi getApplicationService() {
            return this.applicationService;
        }

        public IImportService getImportService() {
            return this.importService;
        }
    }

    private static final class ServiceScriptRunner
    implements IServiceScriptRunner {
        private static final String PROCESS_FUNCTION_NAME = "process";
        private IJythonEvaluator evaluator;
        private ExecutionContext context;

        ServiceScriptRunner(IJythonEvaluator evaluator, ExecutionContext context) {
            this.evaluator = evaluator;
            this.context = context;
            if (!evaluator.hasFunction(PROCESS_FUNCTION_NAME)) {
                throw new EvaluatorException("Function 'process' was not defined in the processing plugin script");
            }
        }

        @Override
        public Serializable process(CustomASServiceExecutionOptions options) {
            Object result = null;
            try {
                result = this.evaluator.evalFunction(PROCESS_FUNCTION_NAME, new Object[]{this.context, options.getParameters()});
            }
            catch (EvaluatorException e) {
                operationLog.error((Object)"Evaluation failed", (Throwable)e);
                Throwable throwable = ExceptionUtils.getEndOfChain((Throwable)e);
                throw CheckedExceptionTunnel.wrapIfNecessary((Throwable)throwable);
            }
            if (result == null || result instanceof Serializable) {
                return (Serializable)result;
            }
            throw new EvaluatorException("Function 'process' dosn't return a serializable object. Object type: " + result.getClass());
        }
    }
}

