/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.service;

import ch.ethz.sis.openbis.generic.asapi.v3.plugin.service.IImportService;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.ICustomImportService;
import ch.systemsx.cisd.openbis.generic.shared.IEntityImportService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="import-service")
public class ImportService
implements IImportService {
    @Autowired
    private IEntityImportService entityImportService;
    @Autowired
    private ICustomImportService customImportService;

    public String createExperiments(String sessionToken, String uploadKey, String experimentTypeCode, boolean async, String userEmail) {
        this.check(sessionToken, uploadKey, experimentTypeCode, async, userEmail);
        ExperimentType experimentType = new ExperimentType();
        experimentType.setCode(experimentTypeCode);
        List<BatchRegistrationResult> results = this.entityImportService.registerExperiments(experimentType, uploadKey, async, userEmail);
        return this.translateResults(results);
    }

    public String updateExperiments(String sessionToken, String uploadKey, String experimentTypeCode, boolean async, String userEmail) {
        this.check(sessionToken, uploadKey, experimentTypeCode, async, userEmail);
        ExperimentType experimentType = new ExperimentType();
        experimentType.setCode(experimentTypeCode);
        List<BatchRegistrationResult> results = this.entityImportService.updateExperiments(experimentType, uploadKey, async, userEmail);
        return this.translateResults(results);
    }

    public String createSamples(String sessionToken, String uploadKey, String sampleTypeCode, String defaultSpaceIdentifier, String spaceIdentifierOverride, String experimentIdentifierOverride, boolean updateExisting, boolean async, String userEmail) {
        this.check(sessionToken, uploadKey, sampleTypeCode, async, userEmail);
        SampleType sampleType = new SampleType();
        sampleType.setCode(sampleTypeCode);
        List<BatchRegistrationResult> results = this.entityImportService.registerSamplesWithSilentOverrides(sampleType, spaceIdentifierOverride, experimentIdentifierOverride, uploadKey, async, userEmail, defaultSpaceIdentifier, updateExisting);
        return this.translateResults(results);
    }

    public String updateSamples(String sessionToken, String uploadKey, String sampleTypeCode, String defaultSpaceIdentifier, String spaceIdentifierOverride, String experimentIdentifierOverride, boolean async, String userEmail) {
        this.check(sessionToken, uploadKey, sampleTypeCode, async, userEmail);
        SampleType sampleType = new SampleType();
        sampleType.setCode(sampleTypeCode);
        List<BatchRegistrationResult> results = this.entityImportService.updateSamplesWithSilentOverrides(sampleType, spaceIdentifierOverride, experimentIdentifierOverride, uploadKey, async, userEmail, defaultSpaceIdentifier);
        return this.translateResults(results);
    }

    public String updateDataSets(String sessionToken, String uploadKey, String dataSetTypeCode, boolean async, String userEmail) {
        this.check(sessionToken, uploadKey, dataSetTypeCode, async, userEmail);
        DataSetType dataSetType = new DataSetType();
        dataSetType.setCode(dataSetTypeCode);
        List<BatchRegistrationResult> results = this.entityImportService.updateDataSets(dataSetType, uploadKey, async, userEmail);
        return this.translateResults(results);
    }

    public String createMaterials(String sessionToken, String uploadKey, String materialTypeCode, boolean updateExisting, boolean async, String userEmail) {
        this.check(sessionToken, uploadKey, materialTypeCode, async, userEmail);
        MaterialType materialType = new MaterialType();
        materialType.setCode(materialTypeCode);
        List<BatchRegistrationResult> results = this.entityImportService.registerMaterials(materialType, updateExisting, uploadKey, async, userEmail);
        return this.translateResults(results);
    }

    public String updateMaterials(String sessionToken, String uploadKey, String materialTypeCode, boolean ignoreUnregistered, boolean async, String userEmail) {
        this.check(sessionToken, uploadKey, materialTypeCode, async, userEmail);
        MaterialType materialType = new MaterialType();
        materialType.setCode(materialTypeCode);
        List<BatchRegistrationResult> results = this.entityImportService.updateMaterials(materialType, uploadKey, ignoreUnregistered, async, userEmail);
        return this.translateResults(results);
    }

    public String generalImport(String sessionToken, String uploadKey, String defaultSpaceIdentifier, boolean updateExisting, boolean async, String userEmail) {
        this.check(sessionToken, uploadKey, async, userEmail);
        List<BatchRegistrationResult> results = this.entityImportService.registerOrUpdateSamplesAndMaterials(uploadKey, defaultSpaceIdentifier, updateExisting, async, userEmail);
        return this.translateResults(results);
    }

    public String customImport(String sessionToken, String uploadKey, String customImportCode, boolean async, String userEmail) {
        this.check(sessionToken, uploadKey, async, userEmail);
        if (customImportCode == null) {
            throw new UserFailureException("Custom import code cannot be null");
        }
        List<BatchRegistrationResult> results = this.customImportService.performCustomImport(uploadKey, customImportCode, async, userEmail);
        return this.translateResults(results);
    }

    protected void check(String sessionToken, String uploadKey, String typeCode, boolean async, String userEmail) {
        this.check(sessionToken, uploadKey, async, userEmail);
        if (typeCode == null) {
            throw new UserFailureException("Type code cannot be null");
        }
    }

    protected void check(String sessionToken, String uploadKey, boolean async, String userEmail) {
        if (sessionToken == null) {
            throw new UserFailureException("Session token cannot be null");
        }
        if (uploadKey == null) {
            throw new UserFailureException("Upload key cannot be null");
        }
        if (async && userEmail == null) {
            throw new UserFailureException("User email cannot be null for an asynchronous import");
        }
    }

    protected String translateResults(List<BatchRegistrationResult> results) {
        StringBuilder message = new StringBuilder();
        Iterator<BatchRegistrationResult> iter = results.iterator();
        while (iter.hasNext()) {
            BatchRegistrationResult result = iter.next();
            if (result == null) continue;
            message.append(result.getMessage());
            if (!iter.hasNext()) continue;
            message.append("\n");
        }
        return message.toString();
    }
}

