/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortParameter;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.authorizationgroup.AuthorizationGroupComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.dataset.DataSetComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.experiment.ExperimentComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.globalsearch.GlobalSearchObjectComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.material.MaterialComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.plugin.PluginComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.project.ProjectComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.property.PropertyAssignmentComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.property.PropertyTypeComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.query.QueryDatabaseComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.SampleComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.space.SpaceComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.tag.TagComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.vocabulary.VocabularyComparatorFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.vocabulary.VocabularyTermComparatorFactory;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class ComparatorFactory {
    private static List<ComparatorFactory> factories = new LinkedList<ComparatorFactory>();

    public abstract boolean accepts(Class<?> var1);

    public abstract Comparator getComparator(String var1, Map<SortParameter, String> var2, ISearchCriteria var3);

    public abstract Comparator getDefaultComparator();

    public static ComparatorFactory getInstance(Class<?> sortOptionsClass) {
        for (ComparatorFactory factory : factories) {
            if (!factory.accepts(sortOptionsClass)) continue;
            return factory;
        }
        return null;
    }

    static {
        factories.add(new GlobalSearchObjectComparatorFactory());
        factories.add(new TagComparatorFactory());
        factories.add(new AuthorizationGroupComparatorFactory());
        factories.add(new VocabularyComparatorFactory());
        factories.add(new VocabularyTermComparatorFactory());
        factories.add(new SpaceComparatorFactory());
        factories.add(new ProjectComparatorFactory());
        factories.add(new ExperimentComparatorFactory());
        factories.add(new SampleComparatorFactory());
        factories.add(new DataSetComparatorFactory());
        factories.add(new MaterialComparatorFactory());
        factories.add(new PropertyTypeComparatorFactory());
        factories.add(new PluginComparatorFactory());
        factories.add(new PropertyAssignmentComparatorFactory());
        factories.add(new QueryDatabaseComparatorFactory());
    }
}

