/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CompositeComparator<OBJECT>
implements Comparator<OBJECT> {
    private List<Comparator<OBJECT>> comparators = new LinkedList<Comparator<OBJECT>>();

    @SafeVarargs
    public CompositeComparator(Comparator<OBJECT> ... comparators) {
        if (comparators == null || comparators.length == 0) {
            throw new IllegalArgumentException("Comparators cannot be null or empty");
        }
        this.comparators = Arrays.asList(comparators);
    }

    @Override
    public int compare(OBJECT o1, OBJECT o2) {
        int result = 0;
        Iterator<Comparator<OBJECT>> iter = this.comparators.iterator();
        while (result == 0 && iter.hasNext()) {
            Comparator<OBJECT> comparator = iter.next();
            result = comparator.compare(o1, o2);
        }
        return result;
    }
}

