/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortParameter;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IEntityTypeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPermIdHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPropertiesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractDateObjectValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractDateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractEntitySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractNumberValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AnyFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AnyPropertySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DatePropertySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IDate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberPropertySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringPropertySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.search.AbstractEntityTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.search.ExperimentTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.search.MaterialTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort.AbstractComparator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class FetchedFieldsScoreComparator<OBJECT extends IEntityTypeHolder & IPropertiesHolder & IPermIdHolder>
extends AbstractComparator<OBJECT, Integer> {
    private AbstractEntitySearchCriteria criteria;
    private List<Pattern> partialMatchTerms = new ArrayList<Pattern>();
    private List<String> exactMatchTerms = new ArrayList<String>();
    private List<Boost> boosts = new ArrayList<Boost>();
    private Map<OBJECT, Integer> scoreCache = new HashMap<OBJECT, Integer>();
    private Integer fullCodeBoost = 0;
    private Integer partialCodeBoost = 0;
    private Integer fullPropertyBoost = 0;
    private Integer fullTypeBoost = 0;
    private Integer partialPropertyBoost = 0;
    private static Map<Class, ISearchCriteriaParser> criteriaParsers = new HashMap<Class, ISearchCriteriaParser>(3);

    public FetchedFieldsScoreComparator(Map<SortParameter, String> parameters, ISearchCriteria criteria) {
        if (criteria == null || !(criteria instanceof AbstractEntitySearchCriteria)) {
            throw new IllegalArgumentException("Missing criteria");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Missing score parameters");
        }
        if (parameters.containsKey(SortParameter.FULL_MATCH_CODE_BOOST)) {
            this.fullCodeBoost = Integer.parseInt(parameters.get(SortParameter.FULL_MATCH_CODE_BOOST));
        }
        if (parameters.containsKey(SortParameter.PARTIAL_MATCH_CODE_BOOST)) {
            this.partialCodeBoost = Integer.parseInt(parameters.get(SortParameter.PARTIAL_MATCH_CODE_BOOST));
        }
        if (parameters.containsKey(SortParameter.FULL_MATCH_PROPERTY_BOOST)) {
            this.fullPropertyBoost = Integer.parseInt(parameters.get(SortParameter.FULL_MATCH_PROPERTY_BOOST));
        }
        if (parameters.containsKey(SortParameter.FULL_MATCH_TYPE_BOOST)) {
            this.fullTypeBoost = Integer.parseInt(parameters.get(SortParameter.FULL_MATCH_TYPE_BOOST));
        }
        if (parameters.containsKey(SortParameter.PARTIAL_MATCH_PROPERTY_BOOST)) {
            this.partialPropertyBoost = Integer.parseInt(parameters.get(SortParameter.PARTIAL_MATCH_PROPERTY_BOOST));
        }
        this.criteria = (AbstractEntitySearchCriteria)criteria;
        this.partialMatchTerms = new ArrayList<Pattern>();
        this.exactMatchTerms = new ArrayList<String>();
        this.boosts = new ArrayList<Boost>();
        for (ISearchCriteria subCriteria : this.criteria.getCriteria()) {
            String[] splitIndexes;
            String value;
            ISearchCriteriaParser parser = criteriaParsers.get(subCriteria.getClass());
            if (parser == null || (value = parser.getValue(subCriteria)) == null) continue;
            this.partialMatchTerms.add(this.getPartialMatchTerm(value));
            this.exactMatchTerms.add(this.getExactMatchTerm(value));
            this.boosts.add(parser.getBoost(subCriteria, 10));
            for (String splitIndex : splitIndexes = value.replace("*", " ").replace("?", " ").replaceAll("\\s+", " ").trim().split(" ")) {
                this.partialMatchTerms.add(this.getPartialMatchTerm(splitIndex));
                this.exactMatchTerms.add(this.getExactMatchTerm(splitIndex));
                this.boosts.add(parser.getBoost(subCriteria, 1));
            }
        }
    }

    @Override
    public int compare(OBJECT o1, OBJECT o2) {
        return -1 * super.compare(o1, o2);
    }

    @Override
    protected Integer getValue(OBJECT o) {
        Integer score = this.scoreCache.get(o);
        if (score == null) {
            score = this.calculateScore(o);
            this.scoreCache.put(o, score);
        }
        return score;
    }

    private boolean hasType(OBJECT o) {
        if (o instanceof Sample) {
            return ((Sample)o).getFetchOptions().hasType();
        }
        if (o instanceof Experiment) {
            return ((Experiment)o).getFetchOptions().hasType();
        }
        if (o instanceof DataSet) {
            return ((DataSet)o).getFetchOptions().hasType();
        }
        if (o instanceof Material) {
            return ((Material)o).getFetchOptions().hasType();
        }
        return false;
    }

    private boolean hasProperties(OBJECT o) {
        if (o instanceof Sample) {
            return ((Sample)o).getFetchOptions().hasProperties();
        }
        if (o instanceof Experiment) {
            return ((Experiment)o).getFetchOptions().hasProperties();
        }
        if (o instanceof DataSet) {
            return ((DataSet)o).getFetchOptions().hasProperties();
        }
        if (o instanceof Material) {
            return ((Material)o).getFetchOptions().hasProperties();
        }
        return false;
    }

    private Integer calculateScore(OBJECT o) {
        int score = 0;
        String code = ((ICodeHolder)o).getCode();
        String typeCode = this.hasType(o) ? o.getType().getCode() : null;
        Map properties = this.hasProperties(o) ? ((IPropertiesHolder)o).getProperties() : null;
        for (int i = 0; i < this.exactMatchTerms.size(); ++i) {
            Pattern partialTerm = this.partialMatchTerms.get(i);
            String exactTerm = this.exactMatchTerms.get(i);
            Boost boost = this.boosts.get(i);
            if (code != null && boost.getCodeBoost() > 0 && this.isPartialMatch(code, partialTerm)) {
                score += this.partialCodeBoost * boost.getCodeBoost();
                if (this.isExactMatch(code, exactTerm)) {
                    score += this.fullCodeBoost * boost.getCodeBoost();
                }
            }
            if (typeCode != null && boost.getTypeCodeBoost() > 0 && this.isExactMatch(typeCode, exactTerm)) {
                score += this.fullTypeBoost * boost.getTypeCodeBoost();
            }
            if (properties == null || properties == null || properties.keySet() == null) continue;
            for (String propertykey : properties.keySet()) {
                String propertyValue;
                if (boost.getPropertyBoost(propertykey) <= 0 || !this.isPartialMatch(propertyValue = (String)properties.get(propertykey), partialTerm)) continue;
                score += this.partialPropertyBoost * boost.getPropertyBoost(propertykey);
                if (!this.isExactMatch(propertyValue, exactTerm)) continue;
                score += this.fullPropertyBoost * boost.getPropertyBoost(propertykey);
            }
        }
        return score;
    }

    private Pattern getPartialMatchTerm(String term) {
        return Pattern.compile(("*" + term + "*").replace("*", ".*").replace("?", ".?"), 2);
    }

    private String getExactMatchTerm(String term) {
        return term.replace("*", "").replace("?", "");
    }

    private boolean isExactMatch(String value, String term) {
        if (value != null && term != null) {
            return value.equalsIgnoreCase(term);
        }
        return false;
    }

    private boolean isPartialMatch(String value, Pattern pattern) {
        if (value != null && pattern != null) {
            return pattern.matcher(value).matches();
        }
        return false;
    }

    static {
        criteriaParsers.put(CodeSearchCriteria.class, new CodeSearchCriteriaParser());
        criteriaParsers.put(PermIdSearchCriteria.class, new PermIdSearchCriteriaParser());
        criteriaParsers.put(StringPropertySearchCriteria.class, new StringPropertySearchCriteriaParser());
        criteriaParsers.put(AnyFieldSearchCriteria.class, new AnyFieldSearchCriteriaParser());
        criteriaParsers.put(AnyPropertySearchCriteria.class, new AnyPropertySearchCriteriaParser());
        criteriaParsers.put(NumberPropertySearchCriteria.class, new NumberPropertySearchCriteriaParser());
        criteriaParsers.put(DatePropertySearchCriteria.class, new DatePropertySearchCriteriaParser());
        criteriaParsers.put(SampleTypeSearchCriteria.class, new AbstractEntityTypeSearchCriteriaParser());
        criteriaParsers.put(ExperimentTypeSearchCriteria.class, new AbstractEntityTypeSearchCriteriaParser());
        criteriaParsers.put(DataSetTypeSearchCriteria.class, new AbstractEntityTypeSearchCriteriaParser());
        criteriaParsers.put(MaterialTypeSearchCriteria.class, new AbstractEntityTypeSearchCriteriaParser());
    }

    private static class Boost {
        private int codeBoost;
        private int typeCodeBoost;
        private int propertyBoost;
        private int propertyDefaultBoost;
        private String propertyName;

        public Boost(int codeBoost, int typeCodeBoost, int propertyDefaultBoost, int propertyBoost, String propertyName) {
            this.codeBoost = codeBoost;
            this.typeCodeBoost = typeCodeBoost;
            this.propertyDefaultBoost = propertyDefaultBoost;
            this.propertyBoost = propertyBoost;
            this.propertyName = propertyName;
        }

        public int getCodeBoost() {
            return this.codeBoost;
        }

        public int getTypeCodeBoost() {
            return this.typeCodeBoost;
        }

        public int getPropertyBoost(String propertyNameToBoost) {
            if (this.propertyName != null && this.propertyName.equals(propertyNameToBoost)) {
                return this.propertyBoost;
            }
            return this.propertyDefaultBoost;
        }
    }

    private static class AbstractEntityTypeSearchCriteriaParser
    implements ISearchCriteriaParser<AbstractEntityTypeSearchCriteria> {
        private AbstractEntityTypeSearchCriteriaParser() {
        }

        @Override
        public String getValue(AbstractEntityTypeSearchCriteria criteria) {
            for (ISearchCriteria subCriteria : criteria.getCriteria()) {
                if (subCriteria instanceof CodeSearchCriteria) {
                    return ((ISearchCriteriaParser)criteriaParsers.get(subCriteria.getClass())).getValue(subCriteria);
                }
                if (!(subCriteria instanceof PermIdSearchCriteria)) continue;
                return ((ISearchCriteriaParser)criteriaParsers.get(subCriteria.getClass())).getValue(subCriteria);
            }
            return null;
        }

        @Override
        public Boost getBoost(AbstractEntityTypeSearchCriteria criteria, int boost) {
            return new Boost(0, boost, 0, 0, null);
        }
    }

    private static class AnyPropertySearchCriteriaParser
    implements ISearchCriteriaParser<AnyPropertySearchCriteria> {
        private AnyPropertySearchCriteriaParser() {
        }

        @Override
        public String getValue(AnyPropertySearchCriteria criteria) {
            return (String)((AbstractStringValue)criteria.getFieldValue()).getValue();
        }

        @Override
        public Boost getBoost(AnyPropertySearchCriteria criteria, int boost) {
            return new Boost(boost, boost, boost, boost, criteria.getFieldName());
        }
    }

    private static class AnyFieldSearchCriteriaParser
    implements ISearchCriteriaParser<AnyFieldSearchCriteria> {
        private AnyFieldSearchCriteriaParser() {
        }

        @Override
        public String getValue(AnyFieldSearchCriteria criteria) {
            return (String)((AbstractStringValue)criteria.getFieldValue()).getValue();
        }

        @Override
        public Boost getBoost(AnyFieldSearchCriteria criteria, int boost) {
            return new Boost(boost, boost, boost, boost, null);
        }
    }

    private static class DatePropertySearchCriteriaParser
    implements ISearchCriteriaParser<DatePropertySearchCriteria> {
        private DatePropertySearchCriteriaParser() {
        }

        @Override
        public String getValue(DatePropertySearchCriteria criteria) {
            IDate date = (IDate)criteria.getFieldValue();
            if (date instanceof AbstractDateObjectValue) {
                return ((Date)((AbstractDateObjectValue)date).getValue()).toString();
            }
            if (date instanceof AbstractDateValue) {
                return (String)((AbstractDateValue)date).getValue();
            }
            return null;
        }

        @Override
        public Boost getBoost(DatePropertySearchCriteria criteria, int boost) {
            return new Boost(0, 0, 0, boost, criteria.getFieldName());
        }
    }

    private static class NumberPropertySearchCriteriaParser
    implements ISearchCriteriaParser<NumberPropertySearchCriteria> {
        private NumberPropertySearchCriteriaParser() {
        }

        @Override
        public String getValue(NumberPropertySearchCriteria criteria) {
            return ((Number)((AbstractNumberValue)criteria.getFieldValue()).getValue()).toString();
        }

        @Override
        public Boost getBoost(NumberPropertySearchCriteria criteria, int boost) {
            return new Boost(0, 0, 0, boost, criteria.getFieldName());
        }
    }

    private static class StringPropertySearchCriteriaParser
    implements ISearchCriteriaParser<StringPropertySearchCriteria> {
        private StringPropertySearchCriteriaParser() {
        }

        @Override
        public String getValue(StringPropertySearchCriteria criteria) {
            return (String)((AbstractStringValue)criteria.getFieldValue()).getValue();
        }

        @Override
        public Boost getBoost(StringPropertySearchCriteria criteria, int boost) {
            return new Boost(0, 0, 0, boost, criteria.getFieldName());
        }
    }

    private static class PermIdSearchCriteriaParser
    implements ISearchCriteriaParser<PermIdSearchCriteria> {
        private PermIdSearchCriteriaParser() {
        }

        @Override
        public String getValue(PermIdSearchCriteria criteria) {
            return (String)((AbstractStringValue)criteria.getFieldValue()).getValue();
        }

        @Override
        public Boost getBoost(PermIdSearchCriteria criteria, int boost) {
            return new Boost(boost, 0, 0, 0, null);
        }
    }

    private static class CodeSearchCriteriaParser
    implements ISearchCriteriaParser<CodeSearchCriteria> {
        private CodeSearchCriteriaParser() {
        }

        @Override
        public String getValue(CodeSearchCriteria criteria) {
            return (String)((AbstractStringValue)criteria.getFieldValue()).getValue();
        }

        @Override
        public Boost getBoost(CodeSearchCriteria criteria, int boost) {
            return new Boost(boost, 0, 0, 0, null);
        }
    }

    private static interface ISearchCriteriaParser<ISearchCriteria> {
        public String getValue(ISearchCriteria var1);

        public Boost getBoost(ISearchCriteria var1, int var2);
    }
}

