/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchIgnore;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.Sorting;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.view.AbstractCollectionView;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.view.ListView;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.view.SetView;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort.ComparatorFactory;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;

public class SortAndPage {
    private Set processed = new HashSet();
    private MethodsCache methodsCache = new MethodsCache();

    public <T, C extends Collection<T>> C sortAndPage(C objects, ISearchCriteria c, FetchOptions fo) {
        Object newObjects = objects;
        if (objects instanceof AbstractCollectionView) {
            newObjects = ((AbstractCollectionView)objects).getOriginalCollection();
        }
        newObjects = this.sort((Collection<?>)newObjects, c, fo);
        newObjects = this.page((Collection)newObjects, fo);
        this.nest((Collection)newObjects, c, fo);
        return newObjects;
    }

    public Collection<?> sort(Collection<?> objects, ISearchCriteria c, FetchOptions fo) {
        if (objects == null || objects.isEmpty()) {
            return objects;
        }
        Comparator comparator = this.getComparator(c, fo);
        if (comparator != null) {
            AbstractCollection sorted = null;
            if (objects instanceof List) {
                sorted = new ArrayList(objects);
                Collections.sort((List)((Object)sorted), comparator);
            } else if (objects instanceof Set) {
                ArrayList temp = new ArrayList(objects);
                Collections.sort(temp, comparator);
                sorted = new LinkedHashSet(temp);
            } else if (objects instanceof Collection) {
                sorted = new ArrayList(objects);
                Collections.sort((List)((Object)sorted), comparator);
            }
            return sorted;
        }
        return objects;
    }

    private Collection page(Collection objects, FetchOptions fo) {
        boolean hasPaging;
        if (objects == null || objects.isEmpty()) {
            return objects;
        }
        boolean bl = hasPaging = fo.getFrom() != null || fo.getCount() != null;
        if (hasPaging) {
            ListView paged = null;
            if (objects instanceof List) {
                paged = new ListView(objects, fo.getFrom(), fo.getCount());
            } else if (objects instanceof Set) {
                paged = new SetView(objects, fo.getFrom(), fo.getCount());
            } else if (objects instanceof Collection) {
                paged = new ListView(objects, fo.getFrom(), fo.getCount());
            } else {
                throw new IllegalArgumentException("Unsupported collection: " + objects.getClass());
            }
            return paged;
        }
        return objects;
    }

    public void nest(Collection objects, ISearchCriteria c, FetchOptions fo) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        FetchOptionsMethods foMethods = this.methodsCache.getFetchOptionsMethods(fo);
        for (Object object : objects) {
            if (this.processed.contains(object)) continue;
            this.processed.add(object);
            ObjectMethods objectMethods = this.methodsCache.getObjectMethods(object);
            for (String fieldName : foMethods.getFieldNames()) {
                try {
                    Set<Object> newValue;
                    Method hasMethod = foMethods.getHasMethod(fieldName);
                    boolean has = (Boolean)hasMethod.invoke((Object)fo, new Object[0]);
                    if (!has) continue;
                    Method withMethod = foMethods.getWithMethod(fieldName);
                    FetchOptions subFo = (FetchOptions)withMethod.invoke((Object)fo, new Object[0]);
                    Method getMethod = objectMethods.getGetMethod(fieldName);
                    Method setMethod = objectMethods.getSetMethod(fieldName);
                    Object value = getMethod.invoke(object, new Object[0]);
                    if (value == null) continue;
                    if (value instanceof Collection) {
                        newValue = this.sortAndPage((Collection)value, c, subFo);
                        setMethod.invoke(object, newValue);
                        continue;
                    }
                    if (value instanceof Map) {
                        this.sortAndPage(((Map)value).values(), c, subFo);
                        continue;
                    }
                    if (subFo.getSortBy() != null && subFo.getSortBy().getSortings() != null && !subFo.getSortBy().getSortings().isEmpty()) {
                        throw new IllegalArgumentException("Nested sort options can be used only for sorting nested collection or map types.");
                    }
                    newValue = this.sortAndPage(Collections.singleton(value), c, subFo);
                    if (setMethod == null) continue;
                    setMethod.invoke(object, newValue.iterator().next());
                }
                catch (Exception e) {
                    throw new RuntimeException("Sorting and paging failed for object: + " + object + " and fieldName: " + fieldName, e);
                }
            }
        }
    }

    protected Comparator getComparator(ISearchCriteria criteria, FetchOptions fetchOptions) {
        List sortings;
        if (fetchOptions == null) {
            return null;
        }
        SortOptions sortBy = fetchOptions.getSortBy();
        Class<?> sortByClass = null;
        if (sortBy != null) {
            sortByClass = sortBy.getClass();
        } else {
            FetchOptionsMethods foMethods = this.methodsCache.getFetchOptionsMethods(fetchOptions);
            sortByClass = foMethods.getSortByClass();
        }
        if (sortBy != null && (sortings = sortBy.getSortings()) != null && !sortings.isEmpty()) {
            final Comparator[] comparators = new Comparator[sortings.size()];
            final int[] directions = new int[sortings.size()];
            int index = 0;
            for (Sorting sorting : sortings) {
                if (sorting.getField() == null) continue;
                ComparatorFactory comparatorFactory = ComparatorFactory.getInstance(sortByClass);
                if (comparatorFactory == null) {
                    throw new IllegalArgumentException("Comparator factory for sort by " + sortByClass + " not found");
                }
                Comparator aComparator = comparatorFactory.getComparator(sorting.getField(), sorting.getParameters(), criteria);
                if (aComparator == null) {
                    throw new IllegalArgumentException("Comparator for field " + sorting.getField() + " not found");
                }
                comparators[index] = aComparator;
                directions[index] = sorting.getOrder().isAsc() ? 1 : -1;
                ++index;
            }
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    for (int i = 0; i < sortings.size(); ++i) {
                        int d = directions[i];
                        Comparator c = comparators[i];
                        int result = d * c.compare(o1, o2);
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }
            };
        }
        ComparatorFactory comparatorFactory = ComparatorFactory.getInstance(sortByClass);
        if (comparatorFactory != null) {
            return comparatorFactory.getDefaultComparator();
        }
        return null;
    }

    private class ObjectMethods {
        private Map<String, Method> getMethods = new HashMap<String, Method>();
        private Map<String, Method> setMethods = new HashMap<String, Method>();

        public ObjectMethods(Class clazz) {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descriptor : descriptors = BeanUtils.getPropertyDescriptors((Class)clazz)) {
                String fieldName = descriptor.getName().substring(0, 1).toUpperCase() + descriptor.getName().substring(1);
                this.getMethods.put(fieldName, descriptor.getReadMethod());
                this.setMethods.put(fieldName, descriptor.getWriteMethod());
            }
        }

        public Method getGetMethod(String fieldName) {
            return this.getMethods.get(fieldName);
        }

        public Method getSetMethod(String fieldName) {
            return this.setMethods.get(fieldName);
        }
    }

    private class FetchOptionsMethods {
        private Collection<String> fieldNames = new HashSet<String>();
        private Map<String, Method> hasMethods = new HashMap<String, Method>();
        private Map<String, Method> withMethods = new HashMap<String, Method>();
        private Class<?> sortByClass;

        public FetchOptionsMethods(Class clazz) {
            try {
                for (Method method : clazz.getMethods()) {
                    if (method.getAnnotation(FetchIgnore.class) != null) continue;
                    if (method.getName().startsWith("has") && !method.getName().equals("hashCode")) {
                        String fieldName = method.getName().substring(3);
                        this.hasMethods.put(fieldName, method);
                        Method withMethod = clazz.getMethod("with" + fieldName, new Class[0]);
                        this.withMethods.put(fieldName, withMethod);
                        this.fieldNames.add(fieldName);
                        continue;
                    }
                    if (!method.getName().equals("sortBy") || this.sortByClass != null && !this.sortByClass.isAssignableFrom(method.getReturnType())) continue;
                    this.sortByClass = method.getReturnType();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Finding methods for fetch options class: " + clazz.getName() + " failed.", e);
            }
        }

        public Class<?> getSortByClass() {
            return this.sortByClass;
        }

        public Collection<String> getFieldNames() {
            return this.fieldNames;
        }

        public Method getHasMethod(String fieldName) {
            return this.hasMethods.get(fieldName);
        }

        public Method getWithMethod(String fieldName) {
            return this.withMethods.get(fieldName);
        }
    }

    private class MethodsCache {
        private Map<Class, Object> cache = new HashMap<Class, Object>();

        private MethodsCache() {
        }

        public FetchOptionsMethods getFetchOptionsMethods(Object fo) {
            FetchOptionsMethods methods = (FetchOptionsMethods)this.cache.get(fo.getClass());
            if (methods == null) {
                methods = new FetchOptionsMethods(fo.getClass());
                this.cache.put(fo.getClass(), methods);
            }
            return methods;
        }

        public ObjectMethods getObjectMethods(Object object) {
            ObjectMethods methods = (ObjectMethods)this.cache.get(object.getClass());
            if (methods == null) {
                methods = new ObjectMethods(object.getClass());
                this.cache.put(object.getClass(), methods);
            }
            return methods;
        }
    }
}

