/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.TagPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;

public class TagAuthorization {
    private IOperationContext context;

    public TagAuthorization(IOperationContext context) {
        this.context = context;
    }

    public void checkAccess(MetaprojectPE tag) {
        if (!this.canAccess(tag.getOwner().getUserId())) {
            throw new UnauthorizedObjectAccessException((IObjectId)new TagPermId(tag.getOwner().getUserId(), tag.getName()));
        }
    }

    public void checkAccess(MetaprojectIdentifier tagIdentifier) {
        if (!this.canAccess(tagIdentifier.getMetaprojectOwnerId())) {
            throw new UnauthorizedObjectAccessException((IObjectId)new TagPermId(tagIdentifier.getMetaprojectOwnerId(), tagIdentifier.getMetaprojectName()));
        }
    }

    public boolean canAccess(MetaprojectPE tag) {
        return this.canAccess(tag.getOwner().getUserId());
    }

    private boolean canAccess(String owner) {
        return owner.equals(this.context.getSession().tryGetPerson().getUserId());
    }
}

