/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.helper.vocabulary;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.VocabularyPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.AbstractListObjectById;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import java.util.LinkedList;
import java.util.List;

public class ListVocabularyByPermId
extends AbstractListObjectById<VocabularyPermId, VocabularyPE> {
    private IVocabularyDAO vocabularyDAO;

    public ListVocabularyByPermId(IVocabularyDAO vocabularyDAO) {
        this.vocabularyDAO = vocabularyDAO;
    }

    @Override
    public Class<VocabularyPermId> getIdClass() {
        return VocabularyPermId.class;
    }

    @Override
    public VocabularyPermId createId(VocabularyPE vocabulary) {
        return new VocabularyPermId(vocabulary.getCode());
    }

    @Override
    public List<VocabularyPE> listByIds(IOperationContext context, List<VocabularyPermId> ids) {
        LinkedList<VocabularyPE> vocabularies = new LinkedList<VocabularyPE>();
        for (VocabularyPermId id : ids) {
            VocabularyPE vocabulary = this.vocabularyDAO.tryFindVocabularyByCode(id.getPermId());
            if (vocabulary == null) continue;
            vocabularies.add(vocabulary);
        }
        return vocabularies;
    }
}

